************************************************************************
* This dofile was written to accompany
* Andrew Leigh, "Bringing home the bacon: An empirical analysis of the extent and effects of pork-barreling in Australian politics"
* Public Choice, forthcoming
* 
* Feel free to adapt the dofile, so long as this paper is cited.
* Questions to andrew_leigh@ksg02.harvard.edu
************************************************************************

version 10
clear
set more off
set mem 5m
cd "C:\Users\Andrew\My publications\Aust - pork barrelling\"

use sustainable_regions.dta, clear
drop if locationelectorate==""
ren grantamountgstinclusive grantamount
gen grantamount_split=grantamount
replace grantamount=. if locationelectorate=="Macarthur/ Werriwa" | locationelectorate=="Wakefield, Makin" | locationelectorate=="Wakefield, Makin,  Port Adelaide" | locationelectorate=="Braddon and Lyons"
gen n=_n
expand 2 if locationelectorate=="Macarthur/ Werriwa" | locationelectorate=="Wakefield, Makin" | locationelectorate=="Braddon and Lyons"
expand 3 if locationelectorate=="Wakefield, Makin,  Port Adelaide"
bysort n: egen seq=seq()
for any "Macarthur/ Werriwa" "Wakefield, Makin" "Braddon and Lyons" "Wakefield, Makin,  Port Adelaide" \ any Macarthur Wakefield Braddon Wakefield: replace locationelectorate="Y" if locationelectorate=="X" & seq==1
for any "Macarthur/ Werriwa" "Wakefield, Makin" "Braddon and Lyons" "Wakefield, Makin,  Port Adelaide" \ any Werriwa Makin Lyons Makin: replace locationelectorate="Y" if locationelectorate=="X" & seq==2
for any "Wakefield, Makin,  Port Adelaide" \ any "Port Adelaide": replace locationelectorate="Y" if locationelectorate=="X" & seq==3
collapse (count) sustainableregions_n=grantamount (sum) sustainableregions=grantamount (sum) sustainableregions_split=grantamount_split, by(locationelectorate)
gen division_abb=substr(locationelectorate,1,4)
sort division_abb
save temp1, replace

use regional_partnerships.dta, clear
drop if locationelectorate=="" | locationelectorate=="Various" | locationelectorate=="various"
collapse (count) regionalpartnerships_n=grantamount (sum) regionalpartnerships=grantamount, by(locationelectorate)
gen division_abb=substr(locationelectorate,1,4)
replace division_abb="KSmi" if locationelectorate=="Kingsford Smith"
sort division_abb
save temp2, replace

use stronger_families.dta, clear
for any Mcewen Mcmillan Mcpherson \ any McEwen McMillan McPherson: replace federal_electorate="Y" if federal_electorate=="X"
collapse (count) strongerfamilies_n=funding_received (sum) strongerfamilies=funding_received, by(federal_electorate)
gen division_abb=substr(federal_electorate,1,4)
replace division_abb="KSmi" if federal_electorate=="Kingsford Smith"
replace division_abb="MPor" if federal_electorate=="Melbourne Ports"
sort division_abb
save temp3, replace

* Getting Antony Green's 2004 pendulum data (01 results on 04 boundaries) into shape
use antony_green_pendulum_pre04.dta, clear
gen temp_party=word(ag_2001,1)
gen temp_margin=substr(ag_2001,-5,4)
replace temp_margin=subinstr(temp_margin," ","",.)
destring temp_margin, force replace
gen pcvote2001=(100+temp_margin)/2 if temp_party=="LIB" | temp_party=="NAT" | temp_party=="CLP"
replace pcvote2001=(100-temp_margin)/2 if pcvote2001==.
gen division_abb=substr(federal_electorate,1,4)
replace division_abb="KSmi" if federal_electorate=="Kingsford Smith (NSW)"
replace division_abb="MPor" if federal_electorate=="Melbourne Ports (VIC)"
drop ag_2001 temp* federal_electorate
sort division_abb
save temp4, replace

* Getting electoral demographics into shape
use electoral_demographics2001.dta,clear
gen division_abb=substr(electoraldivision,1,4)
replace division_abb="KSmi" if electoraldivision=="Kingsford Smith (NSW)"
replace division_abb="MPor" if electoraldivision=="Melbourne Ports (Vic)"
set obs 152
replace division_abb="Bonn" in 151
replace division_abb="Gort" in 152
ren medianfamilyincome income
ren popdensity density2001
ren indigenous indig_share
ren overseas osborn_share
for any income density2001 indig_share osborn_share: egen temp1=mean(X) if division_abb=="Grif" | division_abb=="Bowm" \ egen temp2=max(temp1) \ replace X=temp2 if division_abb=="Bonn" \ egen temp3=mean(X) if division_abb=="Burk" | division_abb=="Calw" | division_abb=="Mari" \ egen temp4=max(temp3) \ replace X=temp4 if division_abb=="Gort" \ drop temp*
keep division_abb income density2001 indig_share osborn_share
sort division_abb
save temp5, replace

* Getting Roads to Recovery cost/benefit data into shape
use roadstorecovery_costbenefit, clear
replace electorate="" if electorate=="See Sheet 2"
gen program_no=_n
expand 2 if electorate=="" & electorate3==""
expand 3 if electorate=="" & electorate3~=""
bysort program_no: egen seq=seq()
gen programshare=1 if electorate~=""
for num 1/3: replace electorate=word(electorateX,1) if seq==X & electorate=="" \ replace programshare=real(word(electorateX,-1))/100 if seq==X & programshare==.
for any pvcost benefits: replace X=X*programshare
replace electorate="La Trobe" if electorate=="La"
gen cost1=pvcost if benefits000~=.
gen benefits1=benefits000
gen cost2=pvcost
gen benefits2=benefits000
recode benefits2 .=0
keep cost1 cost2 benefits1 benefits2 electorate
collapse (sum) cost1 cost2 benefits1 benefits2,by(electorate)
gen bcr1=benefits1/cost1
gen bcr2=benefits2/cost2
gen division_abb=substr(electorate,1,4)
replace division_abb="KSmi" if electorate=="Kingsford"
sort division_abb
save temp6, replace

* Combining the data for different funding programs
cd "C:\Users\Andrew\My publications\Aust - pork barrelling\"
use roadstorecovery.dta, clear
drop density
drop if division=="Northern Territory (NT)" | division=="Namadgi (ACT)"
gen division_abb=substr(division,1,4)
* Mark Davis's R2R data excluded ACT & NT. We add the data back in ($10m per seat)
replace roads=10 if division_abb=="Canb" | division_abb=="Fras" | division_abb=="Ling" | division_abb=="Solo"
replace division_abb="KSmi" if division=="Kingsford Smith (NSW)"
replace division_abb="MPor" if division=="Melbourne Ports (Vic)"
for num 1/6: sort division_abb \ merge division_abb using tempX \ bysort _merge: tab division_abb if _merge~=3 \ tab _merge \ drop _merge
for var sustainableregions sustainableregions_split regionalpartnerships strongerfamilies: replace X=X/1000000 \ recode X .=0
for var *_n: recode X .=0

* SustainableRegions, RegionalPartnerships, and StrongerFamilies were tabulated on 2001 seats
* so we omit from these calculation seats that did not exist in 2001
for var sustainable* regional* stronger*: replace X=. if division_abb=="Bonn" | division_abb=="Gort"

* R2R was tabulated on 2004 seats
* so we omit from these calculation seats that did not exist in 2004
for var roads*: replace X=. if division_abb=="Burk" | division_abb=="Bony"

* For seats created in 2004, we can calculate the swing based 
* on pre-election tabulations (from 2001 booth returns)
replace cvote2001=pcvote2001 if division_abb=="Bonn" | division_abb=="Gort"
replace party="ALP" if division_abb=="Bonn" | division_abb=="Gort"

* For seats with Independents, using Antony Green's predicted 2001 vote is tricky 
* so I merely use actual 2001 vote.
replace pcvote2001=cvote2001 if pcvote2001==.

* Abolished prior to 2004 election, Burke went into Gorton (10000 voters), Lalor (23500 voters), McEwen
* Bonython went into Makin, Port Adelaide (1/3rd of Bonython), Wakefield
egen temp1=mean(cvote2004) if division_abb=="Gort" | division_abb=="Lalo" | division_abb=="McEw" 
egen temp2=max(temp1)
replace cvote2004=temp2 if division_abb=="Burk"
egen temp3=mean(cvote2004) if division_abb=="Maki" | division_abb=="Port" | division_abb=="Wake" 
egen temp4=max(temp3)
replace cvote2004=temp4 if division_abb=="Bony"
drop temp*
* Also, the data are missing party affiliations for these two seats (both ALP)
replace party="ALP" if division_abb=="Bony" | division_abb=="Burk"

for var sustainableregions regionalpartnerships strongerfamilies roads *_n: egen total_X=sum(X)
sum total*

***********************************************
* Figure 1
* Remove slash-asterisk to create the graph
***********************************************
/*
set scheme s1mono
twoway spike sustainableregions cvote2001, xline(50,lpattern(dash) lwidth(medthick)) ti("Sustainable Regions") xtitle("Coalition 2PP vote in 2001") ytitle("Millions of dollars") name(sus, replace) nodraw
twoway spike regionalpartnerships cvote2001, xline(50,lpattern(dash) lwidth(medthick)) ti("Regional Partnerships") xtitle("Coalition 2PP vote in 2001") ytitle("Millions of dollars") name(reg,replace) nodraw
twoway spike roads cvote2001, xline(50,lpattern(dash) lwidth(medthick)) ti("Roads to Recovery") xtitle("Coalition 2PP vote in 2001") ytitle("Millions of dollars") name(roads,replace) nodraw
twoway spike strongerfamilies cvote2001, xline(50,lpattern(dash) lwidth(medthick)) ti("Stronger Families and Communities") xtitle("Coalition 2PP vote in 2001") ytitle("Millions of dollars") name(strong,replace) nodraw
graph combine roads sus reg strong , xcommon ti("Figure 1: Seat margin and amount of targeted funding received")
graph export fig1.tif, replace
graph export fig1.wmf, replace
*/

gen swing=cvote2004-pcvote2001
gen dunemp=u2004-u2001
gen density=1/density2001
gen density2=density^2
replace income=income/1000
gen income2=income^2
gen totalpork=roads+sustainableregions+regionalpartnerships+strongerfamilies
gen celectorate=1 if party=="NP" | party=="LIB" | party=="CLP"
recode celectorate .=0 if party=="ALP" | party=="GRN" | party=="IND"
gen natelectorate=1 if party=="NP" | party=="CLP"
recode natelectorate .=0
gen libelectorate=1 if party=="LIB"
recode libelectorate .=0
gen cvote2001sq=cvote2001^2
for var roads sustainableregions regionalpartnerships strongerfamilies strongerfamilies_n sustainableregions_n regionalpartnerships_n: la var X "X"

* Seats that were created or abolished
list lib nat cvote2001 cvote2004 division sustainableregions regionalpartnerships strongerfamilies roads if division_abb=="Bony" | division_abb=="Burk" | division_abb=="Bonn" | division_abb=="Gort"

*******************************
* Sumstats 
*******************************
sum roads strongerfamilies strongerfamilies_n sustainableregions sustainableregions_n regionalpartnerships regionalpartnerships_n natelectorate libelectorate cvote2001 swing density income

********************************
* Assignment of funding
********************************
* No controls - quantum
for var roads: reg X natelectorate libelectorate, r \ outreg using results1.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("X")
for var sustainableregions regionalpartnerships strongerfamilies : reg X natelectorate libelectorate, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
* Density/income controls - quantum
for var roads sustainableregions regionalpartnerships : reg X natelectorate libelectorate density density2, r  \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for var strongerfamilies: reg X natelectorate libelectorate income income2, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
* Density/income controls - # programs
for var sustainableregions_n regionalpartnerships_n : reg X natelectorate libelectorate density density2, r  \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for var strongerfamilies_n: reg X natelectorate libelectorate income income2, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
* Number of programs (controlling for total grant)
for var sustainableregions regionalpartnerships strongerfamilies: reg X_n natelectorate libelectorate X, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("# progs - X")
for var sustainableregions regionalpartnerships : reg X_n natelectorate libelectorate density density2 X, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("# progs - X")
for var strongerfamilies: reg X_n natelectorate libelectorate income income2 X, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("# progs - X")
* Average grant
for any sustainableregions regionalpartnerships strongerfamilies: gen X_a=X/X_n
for var sustainableregions regionalpartnerships strongerfamilies: reg X_a natelectorate libelectorate, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Avg grant - X")
for var sustainableregions regionalpartnerships : reg X_a natelectorate libelectorate density density2, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Avg grant - X")
for var strongerfamilies: reg X_a natelectorate libelectorate income income2, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Avg grant - X")

* To swing seats or base?
for var roads sustainableregions regionalpartnerships strongerfamilies strongerfamilies_n sustainableregions_n regionalpartnerships_n: reg X cvote2001 if natelectorate==1 | libelectorate==1, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X - Coalition Seats only")
for var roads sustainableregions regionalpartnerships strongerfamilies strongerfamilies_n sustainableregions_n regionalpartnerships_n: reg X cvote2001 cvote2001sq if natelectorate==1 | libelectorate==1, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X - Coalition Seats only")
gen margin=abs(cvote2001-50)
gen marginsq=(cvote2001-50)^2
for var roads sustainableregions regionalpartnerships strongerfamilies strongerfamilies_n sustainableregions_n regionalpartnerships_n: reg X margin, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X - Margin")
for var roads sustainableregions regionalpartnerships strongerfamilies strongerfamilies_n sustainableregions_n regionalpartnerships_n: reg X margin marginsq, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X - Margin")

* Footnote - Benefit/Cost ratio of R2R funding
*for num 1/2: gen bcrX_dummy=bcrX \ recode bcrX_dummy min/1=0 1.00001/10=1
for var bcr1 bcr2 : reg X natelectorate libelectorate, r  \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for var bcr1 bcr2 : reg X natelectorate libelectorate density density2, r  \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")

* Robustness check - stronger families with indigenous and OS born controls
for var strongerfamilies: reg X natelectorate libelectorate income income2 , r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for var strongerfamilies: reg X natelectorate libelectorate income income2 indig_share , r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for var strongerfamilies: reg X natelectorate libelectorate income income2 osborn_share, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for var strongerfamilies: reg X natelectorate libelectorate income income2 indig_share osborn_share, r \ outreg using results1.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")

********************************
* Effect of funding on the vote
********************************
* Dollars & swing
for any roads: reg swing X,r \ outreg using results2.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("Swing-X")
for any strongerfamilies sustainableregions regionalpartnerships: reg swing X,r  \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X") 
for any roads: reg swing X density density2,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any strongerfamilies: reg swing X income income2,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any sustainableregions regionalpartnerships: reg swing X density density2,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any roads strongerfamilies sustainableregions regionalpartnerships : reg swing X pcvote2001,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any roads: reg swing X density density2 pcvote2001,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any strongerfamilies : reg swing X income income2 pcvote2001,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any sustainableregions regionalpartnerships: reg swing X density density2 pcvote2001,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
* Number of programs & swing
for any strongerfamilies sustainableregions regionalpartnerships : reg swing X_n,r  \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X") 
for any strongerfamilies : reg swing X_n income income2,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any sustainableregions regionalpartnerships: reg swing X_n density density2,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any strongerfamilies sustainableregions regionalpartnerships: reg swing X_n pcvote2001,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any strongerfamilies : reg swing X_n income income2 pcvote2001,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
for any sustainableregions regionalpartnerships: reg swing X_n density density2 pcvote2001,r \ outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-X")
* All programs
reg swing roads strongerfamilies sustainableregions regionalpartnerships,r
outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-All")
reg swing roads strongerfamilies sustainableregions regionalpartnerships density density2 income income2,r
outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-All")
reg swing roads strongerfamilies sustainableregions regionalpartnerships pcvote2001,r
outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-All")
reg swing roads strongerfamilies sustainableregions regionalpartnerships density density2 income income2 pcvote2001,r
outreg using results2.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Swing-All")

*******************************
* Data Appendix
*******************************
gen income2001=income*1000
keep division party cvote2001 swing density2001 income2001 roads strongerfamilies strongerfamilies_n sustainableregions sustainableregions_n regionalpartnerships regionalpartnerships_n
order division party cvote2001 swing density2001 income2001 roads strongerfamilies strongerfamilies_n sustainableregions sustainableregions_n regionalpartnerships regionalpartnerships_n
