clear
set mem 40000
set matsize 300

**************************************************************************************************************************************
* Regressions
* Note that the excluded category is the youngest age group (18-29), youngest birth cohort (1980s), poorest quintile, 
* and lowest education category (high school dropouts)
**************************************************************************************************************************************

cd "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\"

use "C:\Documents and Settings\Andrew Leigh\My publications\Aust - forecasting elections\AJPS - Predicting Elections - JJW files\Cameron and Crosby full quarterly data.dta", clear
replace election=year+1900
sum _merge
drop _merge
for any infln gdp unemp realw: drop X \ ren nX X
keep if year1~=. 
keep election infln gdp unemp realw votel left incwin voteinc honeym ww1 ww2 d1931 d1975
replace votel=49 if election==2001
replace voteinc=51 if election==2001
replace incwin=1 if election==2001
replace left=0 if election==2001
for any votel voteinc: replace X=X/100
la var infln "Inflation in election quarter"
la var gdp "GDP growth rate in election quarter"
la var unemp "Unemployment rate in election quarter"
la var realw "Real wage growth in election quarter"
la var honeym "Honeymoon election"
sort election
gen n=_n
tsset n
gen dunemp:"Unemployment rate (change over cycle)"=d.unemp
drop n
sort election
save macroeconomics.dta, replace

* We don't use 1987_aes, since the only thing it has that the 1987_ineq file doesn't is 2nd pref vote
use temp2001, clear
for any 1966 1969 1977 1983 1984 1987_ineq 1990_nsss 1990 1993 1996 1998: sort survey \ merge survey using tempX.dta \ drop _merge
recode survey 1990.1=19901 1990.2=19902
drop if survey==.

replace weight=1 if weight==. 
bysort survey: egen temp=count(weight) 
replace weight=weight*(2000/temp)
move ed_hsonly ed_diploma
gen hincome_raw=hincome
recode hincome 0=1
egen temp1=tag(hincome survey)
bysort survey: egen temp2=sum(temp1)
bysort survey: sum temp2
drop temp*

replace hincome=ln(hincome)
gen hincome2:"HH inc squared/100"=(hincome^2)/100
gen age2:"Age squared/100"=(age^2)/100
* Now, we set edyears=missing (since it only exists for 1987_ineq and 1990_nsss, and we don't want results to be driven by higher variance in these years)
replace edyears=.
replace edyears=10 if ed_hsdropout==1 & edyears==.
replace edyears=12 if ed_hsonly==1 & edyears==.
replace edyears=13.5 if ed_diploma==1 & edyears==.
replace edyears=15 if ed_college==1 & edyears==.
gen edyears2:"Ed years squared/100"=(edyears^2)/100
gen birthyear2:"Birth year squared/100"=(birthyear^2)/100
* Dropping those who were ineligible to vote
drop if age<18
drop if age<21 & election<1973
for num 20(10)60: gen ageX=1 if age>=X & age<(X+10) \ recode ageX .=0 if age~=.
replace age20=1 if age<20
replace age60=1 if age>=60 & age~=.
la var age20 "Aged 18-29"
la var age30 "Aged 30-39"
la var age40 "Aged 40-49"
la var age50 "Aged 50-59"
la var age60 "Aged 60 or over"
for num 1900(10)1980: gen birthyearX=1 if birthyear>=X & birthyear<(X+10) \ recode birthyearX .=0 if birthyear~=.
replace birthyear1900=1 if birthyear<1900
for num 1910(10)1970 \ num 1919(10)1979: la var birthyearX "Born X-Y"
la var birthyear1900 "Born before 1910"
la var birthyear1980 "Born 1980 or after"
gen female_divorced:"Female*Divorced"=female*divorced
gen female_married:"Female*Married"=female*married
for num 1/5: gen quintileX:"Income quintile X"=1 if hincome5==X \ recode quintileX .=0 if hincome~=.
for num 1/10: gen decileX:"Income decile X"=1 if hincome10==X \ recode decileX .=0 if hincome~=.
ren ed_hsdropout edhsdropout
la var ed_college "University degree"
la var ed_hsonly "High school graduate only"
la var female "Female"
la var married "Married"
la var divorced "Divorced"
gen firstelection=birthyear+21
replace firstelection=firstelection-3 if firstelection>=1976
gen firstalp=.
la var firstalp "ALP in power when first eligible to vote"
for X in num 1908 1910 1914 1929 1941 1972 1983 \ Y in num 1909 1913 1917 1932 1949 1975 1996: replace firstalp=1 if firstelection>=X & firstelection<Y
recode firstalp .=0 if birthyear~=.

* SUMMARY STATISTICS - INCLUDING A COMPARISON WITH ACTUAL ELECTION RESULTS
sort election
merge election using actual_alp_vote.dta
tab _merge
drop _merge
log using sumstats_residuals.smcl, replace
bysort survey: tabstat birthyear age female married divorced hincome_raw edyears born_os votealp votealp_2pp firstalp [aw=weight], stats(mean sd n) col(stat)
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election [aw=weight], robust
tabstat birthyear age female married divorced hincome_raw edyears born_os votealp votealp_2pp firstalp election [aw=weight] if e(sample), stats(mean sd n) col(stat)
* Raw gender gap
for num 0/1: bysort election: egen tempX=mean(votealp) if female==X & e(sample) \ bysort election: egen temp_X=max(tempX)
gen gendergap_raw=temp_1-temp_0
bysort election: sum gendergap_raw
drop gendergap_raw temp*
sum votealp [aw=weight] if e(sample)

bysort survey: egen votealp_mean=mean(votealp)
gen error=votealp_mean-votealp_actual
tabstat votealp votealp_actual error, stats(mean) by(survey)
tabstat votealp votealp_actual error if election~=1990, stats(mean) by(survey)
sum error, d
log close

* YEAR BY YEAR 
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os female married if survey==1966 [aw=weight], robust
outreg using table1.doc, coefastr se nocons 3aster bracket replace ct("1966") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
for num 1969 1977 1983 1984 1987: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced if survey==X [aw=weight], robust \ outreg using table1.doc, coefastr se nocons 3aster bracket append ct("X") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
* 1990 AES missing income
for num 19901: dprobit votealp age30-age60 ed_* born_os female married divorced if survey==X [aw=weight], robust \ outreg using table1.doc, coefastr se nocons 3aster bracket append ct("X") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
* 1990 NSSS missing born_os
for num 19902: dprobit votealp age30-age60 ed_* quintile2-quintile5 female married divorced if survey==X [aw=weight], robust \ outreg using table1.doc, coefastr se nocons 3aster bracket append ct("X") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
for num 1993 1996 1998 2001: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced if election==X [aw=weight], robust \ outreg using table1.doc, coefastr se nocons 3aster bracket append ct("X") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))

* POOLED
char election[omit] 1966
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election [aw=weight], robust
tab election if e(sample)
outreg using table2.doc, coefastr se nocons 3aster bracket replace ct("All (No 1990 election, election FE)") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
test ed_hsonly=ed_diploma=ed_college
test ed_hsonly=ed_college
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* female married divorced i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("No born OS, election FE") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
xi: dprobit votealp age30-age60 ed_* born_os female married divorced i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("No inc, election FE") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))

* BY GENDER
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os married divorced i.election [aw=weight] if female==1, robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Women") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os married divorced i.election [aw=weight] if female==0, robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Men") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
*xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election [aw=weight] if union==0, robust
*outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Non-unionists") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
gen fem_union=female*union
gen fem_nonunion=female*(1-union)
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os fem_union fem_nonunion married divorced union i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Union interaction") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
gen div_fem=female*divorced
gen div_male=(1-female)*divorced
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os married female div_fem div_male i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Divorced interaction") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os married divorced union i.election [aw=weight] if female==1, robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Women - with union") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os married divorced union i.election [aw=weight] if female==0, robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Men - with union") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))

* IS EDUCATION EFFECT REALLY PERMANENT INCOME EFFECT?
xi: dprobit votealp age40-age50 quintile2-quintile5 ed_* born_os married divorced i.election [aw=weight] if age>=35 & age<=55 & female==0, robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("M35-55 only: perm inc vs educ") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))

* CAN WE BREAK THE GENDER GAP DOWN A BIT MORE?
for num 1/5: gen femquintileX=quintileX*female 
for var ed_* age30-age60 born_os: gen femX=X*female
xi: dprobit votealp fem* age30-age60 quintile2-quintile5 ed_* born_os married divorced i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Gender gap - all possible interactions") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
xi: dprobit votealp female femage30-femage60 age30-age60 quintile2-quintile5 ed_* born_os married divorced i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Gender gap - age interactions") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))

* IS AGE EFFECT REALLY COHORT EFFECT? 
gen by1929=1 if birthyear<1930
gen by1930=1 if birthyear>=1930 & birthyear<=1944
gen by1945=1 if birthyear>=1945 & birthyear<=1960
gen by1961=1 if birthyear>1960 & birthyear~=.
for any 1929 1930 1945 1961: recode byX .=0 if birthyear~=.
for any 1929 1930 1945 1961: bysort election: egen temp=mean(votealp) if byX==0 \ bysort election: egen v_notX=max(temp) \ drop temp
for any 1929: dprobit votealp age40-age60 quintile2-quintile5 ed_* born_os female married divorced v_notX [aw=weight] if byX==1, robust \ outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Born X") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
for any 1930 1945 1961: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced v_notX [aw=weight] if byX==1, robust \ outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Born X") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))

* SWINGERS 
gen previous_election=.
gen votealp_actual_prev=.
for num 1969 1977 1983 1984 1987 1993 1996 1998 2001 \ num 1966 1975 1980 1983 1984 1990 1993 1996 1998: replace previous_election=Y if election==X \ gen temp1=votealp_actual if election==Y \ egen temp2=max(temp1) \ replace votealp_actual_prev=temp2 if election==X \ drop temp*
bysort previous_election: egen votealp_mean_prev=mean(votealp_previous)
gen error_prev=votealp_mean_prev-votealp_actual_prev
gen lablab=votealp_previous*votealp
gen labcoal=votealp_previous*(1-votealp)
gen coallab=(1-votealp_previous)*votealp
gen coalcoal=(1-votealp_previous)*(1-votealp)
gen oth=1 if votealp==.
gen oth_prev=1 if votealp_previous==.
gen othcoal=oth_prev*(1-votealp)
gen othlab=oth_prev*votealp
gen othoth=oth_prev*oth
gen laboth=votealp_previous*oth
gen coaloth=(1-votealp_previous)*oth
for var oth* coal* lab*: recode X .=0
log using sumstats_residuals.smcl, append
tabstat votealp_previous votealp_actual_prev error_prev, stats(mean) by(previous_election)
tabstat lablab labcoal laboth coallab coalcoal coaloth othlab othcoal othoth, stats(sum mean) by(previous_election)
log close
gen swinger=1 if (votealp==1 & votealp_previous==0) | (votealp==0 & votealp_previous==1)
gen swinger_alp=1 if votealp==1 & votealp_previous==0
gen swinger_coal=1 if votealp==0 & votealp_previous==1
for any swinger swinger_alp swinger_coal: recode X .=0 if votealp~=. & votealp_previous~=.
sum swinger*
xi: dprobit swinger age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Dep Var: Swingers (either way)") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
xi: dprobit swinger_alp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Dep Var: ALP Swingers") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
xi: dprobit swinger_coal age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election [aw=weight], robust
outreg using table2.doc, coefastr se nocons 3aster bracket append ct("Dep Var: Coal Swingers") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))

* ALLOWING VARIABLES TO TREND
for var age30-age60 birthyear quintile2-quintile5 ed_* born_os female married divorced: gen trendX=((election-1966)*X)/35
gen trend=(election-1966)/35
ren trendbirthyear temp
xi: dprobit votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced trend* i.election [aw=weight], robust
outreg using table3.doc, coefastr se nocons 3aster bracket replace ct("Trends") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
ren temp trendbirthyear

* CREATING GRAPHS OF RESIDUALS - income, education, age, birthyear
xi: dprobit votealp age30-age60 ed_* born_os female married divorced i.election [aw=weight], robust
predict res
replace res=votealp-res
log using sumstats_residuals.smcl, append
table hincome10, contents(mean res)
log close
drop res
xi: dprobit votealp age30-age60 hincome born_os female married divorced i.election [aw=weight], robust
predict res
replace res=votealp-res
log using sumstats_residuals.smcl, append
table edyears, contents(mean res)
log close
drop res
reg votealp_normed birthyear1900-birthyear1970 hincome ed_* born_os female married divorced [aw=weight], robust
predict res, resid
gen agedec=.
for num 20(10)80: replace agedec=X if age>=X & age<X+10
replace agedec=20 if agedec<20
replace agedec=80 if agedec>89
log using sumstats_residuals.smcl, append
table agedec, contents(mean res)
log close
drop res agedec
reg votealp_normed age30-age60 hincome ed_* born_os female married divorced [aw=weight], robust
predict res, resid
gen birthyeardec=.
for num 1900(10)1980: replace birthyeardec=X if birthyearX==1
log using sumstats_residuals.smcl, append
table birthyeardec, contents(mean res)
log close
drop res birthyeardec

* USING POSTCODE-LEVEL AVERAGE INCOME, INEQUALITY, ETHNIC FRACT, LINGUISTIC FRACT
ren postcode dpostcod
replace dpostcod=. if election<1993
sort dpostcod
merge dpostcod using "C:\Documents and Settings\Andrew Leigh\My publications\Social capital in Australia\Census Postcode Data\all\Ginis & fract indices (all levels).dta"
tab _merge
drop _merge
la var gini "Inequality in neighbourhood"
la var lnmeanwkinc "Log mean income in neighbourhood"
la var overseasborn "Fraction in neighbourhood born overseas"
gen os_osborn:"Born overseas*Fraction in neighbourhood born overseas"=born_os*overseasborn
gen os_osborn_l:"Born overseas*Fraction in neighbourhood born overseas"=born_os*overseasborn_l
gen native=born_os
recode native 0=1 1=0
gen os_native:"Native*Fraction in neighbourhood born overseas"=native*overseasborn
gen os_native_l:"Native*Fraction in neighbourhood born overseas"=native*overseasborn_l
for num 1/5: gen mean_quintileX:"Income quintile X*Mean neighbourhood income"=lnmeanwkinc*quintileX \ gen meanl_quintileX:"Income quintile X*Mean locality income"=lnmeanwkinc_l*quintileX
for num 1/5: gen gini_quintileX=gini*quintileX \ gen ginil_quintileX=gini_l*quintileX 
gen meanyrinc=meanwkinc*52
log using sumstats_residuals.smcl, append
tabstat meanyrinc overseasborn gini [aw=weight], stats(mean sd n) col(stat)
log close
xi: dprobit votealp lnmeanwkinc gini overseasborn age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election [aw=weight], robust cluster(dpostcod)
outreg using table3.doc, coefastr se nocons 3aster bracket append ct("Probit") bdec(3) addstat(Pseudo R-squared, e(r2_p), Observed Probability, e(pbar))
xi: reg votealp lnmeanwkinc gini overseasborn age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election [aw=weight], robust cluster(dpostcod)
outreg using table3.doc, coefastr se nocons 3aster bracket append ct("OLS") bdec(3) 
xi: ivreg votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election (lnmeanwkinc gini overseasborn=lnmeanwkinc_l gini_l overseasborn_l) [aw=weight], robust cluster(dpostcod)
outreg using table3.doc, coefastr se nocons 3aster bracket append ct("IV using locality") bdec(3) 
xi: ivreg votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election (lnmeanwkinc gini overseasborn=lnmeanwkinc_s gini_s overseasborn_s) [aw=weight], robust cluster(dpostcod)
outreg using table3.doc, coefastr se nocons 3aster bracket append ct("IV using state") bdec(3) 
xi: ivreg votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election (lnmeanwkinc gini os_native os_osborn=lnmeanwkinc_l gini_l os_native_l os_osborn_l) [aw=weight], robust cluster(dpostcod)
outreg using table3.doc, coefastr se nocons 3aster bracket append ct("IV - OS interactions") bdec(3) 
xi: ivreg votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election (mean_quintile1 mean_quintile2 mean_quintile3 mean_quintile4 mean_quintile5 gini overseasborn=meanl_quintile1 meanl_quintile2 meanl_quintile3 meanl_quintile4 meanl_quintile5 gini_l overseasborn_l) [aw=weight], robust cluster(dpostcod)
outreg using table3.doc, coefastr se nocons 3aster bracket append ct("IV - meaninc interactions") bdec(3) 
xi: ivreg votealp age30-age60 quintile2-quintile5 ed_* born_os female married divorced i.election (gini_quintile1 gini_quintile2 gini_quintile3 gini_quintile4 gini_quintile5 lnmeanwkinc overseasborn=ginil_quintile1 ginil_quintile2 ginil_quintile3 ginil_quintile4 ginil_quintile5 lnmeanwkinc_l overseasborn_l) [aw=weight], robust cluster(dpostcod)
outreg using table3.doc, coefastr se nocons 3aster bracket append ct("IV - ineq interactions") bdec(3) 

* MACROECONOMIC VARIABLES
sort election
merge election using macroeconomics.dta
tab _merge
drop _merge
bysort election: sum votel votealp votealp_2pp 
* This next line adjusts the macro variables so 1=5% increase in unemp, infl, gdp, realw etc.
* for any unemp infln gdp realw: replace X=X/5 
* The next coding is based on left, which denotes whether the ALP won, and incwin, which denotes whether the incumbent won.
* If these two variables are both 1 or both 0, then the incumbent was ALP. If they're different, then the incumbent was Coalition.
gen alp_incumbent=1 if left==incwin
replace alp_incumbent=0 if left~=incwin & left~=. & incwin~=.
egen tag=tag(election)
gen alp_honeym:"ALP honeymoon"=alp_incumbent*honeym
reg voteinc dunemp infln if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket replace ct("Incumbent - Jackman & Marks 1994") bdec(3)
reg voteinc dunemp infln honeym if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("Incumbent - Jackman 1995") bdec(3)
reg voteinc unemp infln gdp realw honeym ww1 ww2 d1931 d1975 if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("Incumbent - Cameron & Crosby 2000") bdec(3)
reg votel unemp alp_incumbent if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("ALP - unemp only") bdec(3)
reg votel infln alp_incumbent if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("ALP - inflation only") bdec(3)
reg votel gdp alp_incumbent if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("ALP - gdp only") bdec(3)
reg votel realw alp_incumbent if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("ALP - realw only") bdec(3)
reg votel dunemp infln alp_incumbent if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("ALP - Jackman & Marks 1994") bdec(3)
reg votel dunemp infln alp_incumbent alp_honeym if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("ALP - Jackman 1995") bdec(3)
reg votel unemp infln gdp realw alp_incumbent alp_honeym ww1 ww2 d1931 d1975 if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("ALP - Cameron & Crosby 2000") bdec(3)

gen u_alp=unemp*alp_incumbent
gen u_coal=unemp*(1-alp_incumbent)
reg votel u_alp u_coal alp_incumbent if tag, robust 
outreg using table4.doc, coefastr se nocons 3aster bracket append ct("ALP - unemp only") bdec(3)
