clear
set mem 30000
set matsize 300

* Note that divorced includes separated.

*********
* 2001 AES
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\AES2001\aes2001.postcode.dta", clear
gen union=h6
recode union 2=0
gen birthyear=i2+1900
gen age=2001-birthyear
gen born_os=0 if i3own==1
replace born_os=1 if i3own~=1 &  i3own~=.
la var born_os "Born overseas"
gen female=i1
recode female 1=0 2=1
gen married=i7
recode married 2=1 .=. *=0
gen divorced=i7
recode divorced 4=1 .=. *=0
gen hincome=i17
recode hincome 1=2500 2=7500 3=12500 4=17500 5=22500 6=27500 7=32500 8=37500 9=42500 10=47500 11=55000 12=65000 13=75000 14=85000 15=95000 16=105000
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
* For 2001, we use h1 (age left school), and h3 (highest tertiary qualification)
gen ed_diploma=h3
recode ed_diploma 4/7=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=h3
recode ed_college 2=1 3=1 .=. *=0
gen ed_hsdropout=1 if h1<17 & ed_diploma==0 & ed_college==0
recode ed_hsdropout .=0 if h1~=.
gen ed_hsonly=1 if h1>=17 & h1<=24 & ed_diploma==0 & ed_college==0
recode ed_hsonly .=0 if h1~=.
* Voting (with preferences)
gen votealp=b11reps
recode votealp 2=1 1=0 3=0 *=.
gen votealp_2pp=b11reps
recode votealp_2pp 2=1 1=0 3=0 *=.
replace votealp_2pp=1 if votealp_2pp==. & b12reps==2
replace votealp_2pp=0 if votealp_2pp==. & b12reps==1
* 2 options for prev vote. b16 asks explicitly which party you voted for last time, but don't ask about
* preferences. b18p1 asks simply whether you *always* vote the same way.  We use b16.
gen votealp_previous=b16
recode votealp_previous 2=1 1=0 *=.
gen election=2001
keep election age birthyear born_os female married divorced hincom* ed_* votealp* postcode union 
gen survey=2001
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp2001.dta", replace

*********
* 1998 AES
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\AES1998\aes1998.postcode.dta", clear
gen union=h6
recode union 2=0
gen birthyear=i2+1900
gen age=1998-birthyear
gen born_os=0 if i3own==1
replace born_os=1 if i3own~=1 &  i3own~=.
la var born_os "Born overseas"
gen female=i1
recode female 1=0 2=1
gen married=i7
recode married 2=1 .=. *=0
gen divorced=i7
recode divorced 4=1 .=. *=0
gen hincome=i14
recode hincome 1=2500 2=7500 3=12500 4=17500 5=22500 6=27500 7=32500 8=37500 9=42500 10=47500 11=55000 12=65000 13=75000 14=85000 15=95000 16=105000
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
gen ed_diploma=h3
recode ed_diploma 4/7=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=h3
recode ed_college 2/3=1 .=. *=0
gen ed_hsdropout=1 if h1<17 & ed_diploma==0 & ed_college==0
recode ed_hsdropout .=0 if h1~=.
gen ed_hsonly=1 if h1>=17 & h1<=24 & ed_diploma==0 & ed_college==0
recode ed_hsonly .=0 if h1~=.
* Voting (with preferences)
gen votealp=b11reps
recode votealp 2=1 1=0 3=0 *=.
gen votealp_2pp=b11reps
recode votealp_2pp 2=1 1=0 3=0 *=.
replace votealp_2pp=1 if votealp_2pp==. & b12reps==2
replace votealp_2pp=0 if votealp_2pp==. & b12reps==1
gen votealp_previous=b16
recode votealp_previous 2=1 1=0 *=.
gen election=1998
keep election age birthyear born_os female married divorced hincom* ed_* votealp* postcode union
gen survey=1998
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1998.dta", replace

*********
* 1996 AES
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\AES1996\aes1996.postcode.dta", clear
gen union=h6
recode union 2=0
gen birthyear=j2+1900
gen age=1996-birthyear
gen born_os=0 if j3own==1
replace born_os=1 if j3own~=1 &  j3own~=.
la var born_os "Born overseas"
gen female=j1
recode female 1=0 2=1
gen married=j8
recode married 2=1 .=. *=0
gen divorced=j8
recode divorced 4=1 .=. *=0
gen hincome=j12
recode hincome 1=1500 2=4000 3=6500 4=10000 5=14000 6=18000 7=22500 8=27500 9=32500 10=37500 11=45000 12=55000 13=65000 14=75000
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
gen ed_diploma=h2
recode ed_diploma 5/7=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=h2
recode ed_college 2/4=1 .=. *=0
gen ed_hsdropout=1 if h1<17 & ed_diploma==0 & ed_college==0
recode ed_hsdropout .=0 if h1~=.
gen ed_hsonly=1 if h1>=17 & h1<=24 & ed_diploma==0 & ed_college==0
recode ed_hsonly .=0 if h1~=.
* Voting (with preferences)
gen votealp=b9reps
recode votealp 2=1 1=0 3=0 *=.
gen votealp_2pp=b9reps
recode votealp_2pp 2=1 1=0 3=0 *=.
replace votealp_2pp=1 if votealp_2pp==. & b10reps==2
replace votealp_2pp=0 if votealp_2pp==. & b10reps==1
gen votealp_previous=b14
recode votealp_previous 2=1 1=0 *=.
gen election=1996
keep election age birthyear born_os female married divorced hincom* ed_* votealp* postcode union
gen survey=1996
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1996.dta", replace

*********
* 1993 AES
* NB. Here, we have weight & postcode
* NB. We don't have 2nd preference vote in this dataset.
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\AES1993\aes1993.dta", clear
gen union=j10
recode union 2=1 3=0
gen birthyear=j2+1900
gen age=1993-birthyear
gen born_os=0 if j3own==1
replace born_os=1 if j3own~=1 &  j3own~=.
la var born_os "Born overseas"
gen female=j1
recode female 1=0 2=1
gen married=j12
recode married 2=1 .=. *=0
gen divorced=j12
recode divorced 4=1 .=. *=0
gen hincome=j14
recode hincome 1=1500 2=4000 3=6500 4=10000 5=14000 6=18000 7=22500 8=27500 9=32500 10=37500 11=45000 12=55000 13=65000 14=75000
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
gen ed_diploma=i3
recode ed_diploma 5/8=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=i3
recode ed_college 2=1 3=1 4=1 .=. *=0
gen ed_hsdropout=1 if i1<17 & ed_diploma==0 & ed_college==0
recode ed_hsdropout .=0 if i1~=.
gen ed_hsonly=1 if i1>=17 & i1<=24 & ed_diploma==0 & ed_college==0
recode ed_hsonly .=0 if i1~=.
* Voting 
gen votealp=b6reps
recode votealp 2=1 1=0 3=0 *=.
gen votealp_previous=b9reps
recode votealp_previous 2=1 1=0 *=.
ren weight weight_old
gen weight=weight_old/.7859716
gen election=1993
keep election age birthyear born_os female married divorced hincom* ed_* votealp* weight postcode union
gen survey=1993
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1993.dta", replace

*********
* 1990 AES --> NOT USED IN "ECONOMIC VOTING AND ELECTORAL BEHAVIOR"
* NB. Here, we have postcode
* NB. We don't have 2nd preference vote 
* We don't have income
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\AES1990\aes1990.dta", clear
gen union=j10
recode union 2=1 3=0
gen birthyear=j2+1900
gen age=1990-birthyear
gen born_os=0 if j3own==1
replace born_os=1 if j3own~=1 &  j3own~=.
la var born_os "Born overseas"
gen female=j1
recode female 1=0 2=1
gen married=j9
recode married 2=1 .=. *=0
gen divorced=j9
recode divorced 4=1 .=. *=0
*gen hincome=j14
*recode hincome 1=1500 2=4000 3=6500 4=10000 5=14000 6=18000 7=22500 8=27500 9=32500 10=37500 11=45000 12=55000 13=65000 14=75000
gen ed_diploma=i4
recode ed_diploma 4/6=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=i4
recode ed_college 2/3=1 .=. *=0
gen ed_hsdropout=1 if i1<17 & ed_diploma==0 & ed_college==0
recode ed_hsdropout .=0 if i1~=.
gen ed_hsonly=1 if i1>=17 & i1<=24 & ed_diploma==0 & ed_college==0
recode ed_hsonly .=0 if i1~=.
* Voting 
gen votealp=b6reps
recode votealp 2=1 1=0 3=0 *=.
gen votealp_previous=b8reps
recode votealp_previous 2=1 1=0 *=.
gen election=1990
keep election age birthyear born_os female married divorced ed_* votealp* union
gen survey=1990.1
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1990.dta", replace

*********
* 1990 NSSS Election Panel  --> NOT USED IN "ECONOMIC VOTING AND ELECTORAL BEHAVIOR"
* No born overseas
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\NSSS1990election\d0630.dta", clear
ren iage age
recode age 99=.
gen birthyear=1990-age
* All questionaires returned in 1990
gen born_os=.
gen female=isex
recode female 1=0 2=1 *=.
gen married=imarried
recode married 2=1 3/6=0 9=.
gen divorced=imarried
recode divorced 4/5=1 2/3=0 6=0 9=.
gen hincome=ifaminc
recode hincome 9999999=.
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
recode ieduci 95=.
gen ed_college=1 if ieduci>=15 & ieduci~=.
gen ed_diploma=1 if ieduci==13 | ieduci==14
gen ed_hsonly=1 if ieduci==12
gen ed_hsdropout=1 if ieduci<=11
for any ed_college ed_diploma ed_hsonly ed_hsdropout: recode X .=0 if ieduci~=.
ren ieduci edyears
* Voting (with preferences)
gen votealp=vot901
recode votealp 2=1 1=0 3=0 *=.
gen votealp_2pp=votealp
replace votealp_2pp=1 if votealp_2pp==. & vot902==2
replace votealp_2pp=0 if votealp_2pp==. & (vot902==1 | vot902==3)
gen votealp_previous=vot87rcl
recode votealp_previous 2=1 1=0 3=0 *=.
gen election=1990
ren pcode postcode
keep election age birthyear born_os female married divorced ed_* votealp* hincom* edyears postcode
gen survey=1990.2
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1990_nsss.dta", replace

*********
* 1987 AES --> NOT USED IN "ECONOMIC VOTING AND ELECTORAL BEHAVIOR"
* NB. Here, we have postcode
* NB. We don't have 2nd preference vote 
* We don't have income
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\AES1987\aes1987.dta", clear
gen union=q68
recode union 2=0
replace q74=q74-100 if q74>90
gen birthyear=q74+1900
gen age=1987-birthyear
gen born_os=q75rcob
recode born_os 1/8=0 .=. *=1
la var born_os "Born overseas"
gen female=q71
recode female 1=0 2=1
gen married=q80
recode married 2=1 .=. *=0
gen divorced=q80
recode divorced 4/5=1 .=. *=0
gen ed_diploma=q64
recode ed_diploma 4/6=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=q64
recode ed_college 2/3=1 .=. *=0
gen ed_hsdropout=1 if q61<17 & ed_diploma==0 & ed_college==0
recode ed_hsdropout .=0 if q61~=.
gen ed_hsonly=1 if q61>=17 & q61<=24 & ed_diploma==0 & ed_college==0
recode ed_hsonly .=0 if q61~=.
* Voting 
gen votealp=q5reps
recode votealp 2=1 1=0 3=0 *=.
gen votealp_previous=q8reps
recode votealp_previous 2=1 1=0 *=.
gen election=1987
keep election age birthyear born_os female married divorced ed_* votealp* postcode union
gen survey=1987.1
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1987_aes.dta", replace

*********
* 1987 NSSS Inequality
* No voting preferences
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\NSSS1987-88ineq\d0627.dta", clear
gen union=tumember
recode union 1/2=0 3=1 9=.
ren bornyear birthyear
recode birthyear 99=.
replace birthyear=birthyear+1900
replace birthyear=birthyear-100 if birthyear>1970
recode returnyr 0=1987 1=1988
gen age=returnyr-birthyear
gen born_os=wherebrn
recode born_os 1/6=0 12/13=0 0=. *=1
gen female=sex
recode female 1=0 2=1 *=.
gen married=1 if marstat==2 & hhspouse==1
recode married .=0
gen divorced=1 if married==0 & (mar1endh==3 | mar1endh==4 | mar2endh==3 | mar2endh==4 | mar3endh==3 | mar3endh==4 )
recode divorced .=0
gen hincome=ifaminc
recode hincome 9999999=.
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
recode iedyrs 95/99=.
gen ed_college=1 if iedyrs >=15 & iedyrs ~=.
gen ed_diploma=1 if iedyrs==13 | iedyrs==14
gen ed_hsonly=1 if iedyrs==12
gen ed_hsdropout=1 if iedyrs<=11
for any ed_college ed_diploma ed_hsonly ed_hsdropout: recode X .=0 if iedyrs~=.
ren iedyrs edyears
* Voting (WITHOUT preferences)
gen votealp=vothr87
recode votealp 2=1 1=0 3=0 *=.
gen votealp_previous=vothr84
recode votealp_previous 2=1 1=0 3=0 *=.
gen election=1987
keep election age birthyear born_os female married divorced ed_* votealp* hincom* edyears union
gen survey=1987
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1987_ineq.dta", replace

*********
* 1984 NSSS
*********
infix 17 lines 2: rborn 56-58 3: educ 49-50 hqual 57-59 bornyear 79-80 5: totinc 62-68 10: marstat 51 12: sex 12 age 13-14 vot84 39 vot84no 40 vot83 43 vot83no 44 union 47 using "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\NSSS1984\D423.DAT", clear
recode union 2=1 1=0 -1=. 9=.
recode age 99=.
gen birthyear=1984-age
gen born_os=rborn
recode born_os 1/6=0 12/13=0 84/85=0 999=. *=1
la var born_os "Born overseas"
gen female=sex
recode female 1=0 2=1 *=.
gen married=marstat
recode married 2=1 9=. .=. *=0
gen divorced=marstat
recode divorced 4/5=1 9=. .=. *=0
gen hincome=totinc
recode hincome 9999997/9999999=. 
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
gen ed_diploma=hqual
recode ed_diploma 301/737=1 903/904=. .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=hqual
recode ed_college 1/276=1 903/904=. .=. *=0
gen ed_hsdropout=educ
recode ed_hsdropout 0/11=1 95/99=. .=. *=0
replace ed_hsdropout=0 if ed_diploma==1 | ed_college==1
gen ed_hsonly=educ
recode ed_hsonly 12=1 95/99=. .=. *=0
replace ed_hsonly=0 if ed_diploma==1 | ed_college==1
* Voting 
gen votealp=vot84
recode votealp 2=1 1=0 3=0 *=.
* The next line is necessary b/c the vot84 variable asks those who didn't vote how they would have voted.
replace votealp=. if vot84no==1
gen votealp_previous=vot83
recode votealp_previous 2=1 1=0 *=.
replace votealp_previous=. if vot83no==1
gen election=1984
keep election age birthyear born_os female married divorced ed_* votealp* hincom* union
gen survey=1984
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1984.dta", replace

*********
* Reark 1983
* No 2nd preference vote
* Divorced & widowed are smooshed together, so we assume that all wid/div aged <55 are divorced (seems sensible from looking at age patterns of divorcees and widows in other years)
* Includes income
* Includes postcode
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\Reark1983\d0158.dta", clear
gen age=prage
recode age 1=. 2=18.5 3=22 4=27 5=32 6=37 7=42 8=47 9=52 10=57 11=62 12=67
gen birthyear=1983-age
gen born_os=prcntry
recode born_os 1=0 .=. *=1
la var born_os "Born overseas"
gen female=prsex
recode female 1=0 2=1 *=.
gen married=prmaritl
recode married 1/4=1 .=. *=0
gen divorced=1 if (prmaritl==5 | prmaritl==6) & age<55
recode divorced .=0 if prmaritl~=.
gen hincome=hhincom
recode hincome 1=1500 2=4500 3=7000 4=9000 5=11000 6=14000 7=18000 8=22500 9=27500 10=35000 11=45000
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
gen ed_diploma=preductn
recode ed_diploma 5/6=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=preductn
recode ed_college 7/8=1 .=. *=0
gen ed_hsdropout=preductn
recode ed_hsdropout 1/3=1 .=. *=0
gen ed_hsonly=preductn
recode ed_hsonly 4=1 .=. *=0
* Voting 
gen votealp=q4
recode votealp 1=1 3/4=0 *=.
gen votealp_previous=q5
recode votealp_previous 1=1 3/4=0 *=.
gen election=1983
keep election age birthyear born_os female married divorced ed_* votealp* hincom* postcode
gen survey=1983
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1983.dta", replace

*********
* Macquarie 1979 survey (for 1977 election)
* No 2nd preference vote
* Includes income
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\Macquarie1979\d0009.dta", clear
gen union=tumem
recode union 5=0 0=.
gen age=age79
recode age 0=. 99=.
gen birthyear=1979-age
gen born_os=arrive79
recode born_os 1/8=1
la var born_os "Born overseas"
gen female=sex79
recode female 1=0 2=1 *=.
gen married=maritl79
recode married 2=1 0=. 9=. .=. *=0
gen divorced=maritl79
recode divorced 3/4=1 0=. 9=. .=. *=0
gen hincome=income1
recode hincome 0=. 9=. 1=1500 2=3750 3=6000 4=9000 5=12000 6=15000 7=18000 8=21000
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
recode educat79 0=.
gen ed_diploma=educat79
recode ed_diploma 6/7=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=educat79
recode ed_college 8=1 .=. *=0
gen ed_hsdropout=educat79
recode ed_hsdropout 1/4=1 .=. *=0
gen ed_hsonly=educat79
recode ed_hsonly 5=1 .=. *=0
* Voting
gen votealp=fed77vot
recode votealp 2=1 1=0 3=0 *=.
gen votealp_previous=fed75vot
recode votealp_previous 2=1 1=0 3=0 *=.
gen election=1977
keep election age birthyear born_os female married divorced ed_* votealp* hincom* union
gen survey=1977
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1977.dta", replace

*********
* AES 1969 survey (for 1969 election)
*********
infix 9 lines 5: v645 19-20 v646 21 v647 22 v655 30 v656 31 7: v753 17 v773 42-45 v774 46 v789 67 8: v801 24-25 v802 26-27 v803 28-29 v804 30-30 v805 31 v806 32-33 v807 34-35 v808 36-36 v809 37 v810 38 v823 51 9: v864 40 v866 42 v867 43-44 using "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\AES1969\AES1969.dat", clear
la var v645 "First fed election vote"
la var v646 "Party vote in first elect"
la var v647 "Vote 1966 election"
la var v655 "Vote 1969 fed elect"
la var v656 "2nd pref 1969 fed elect"
la var v753 "Trade union membership"
la var v773 "Birthplace respondent"
la var v774 "Year arrived Australia"
la var v789 "R's level education"
la var v823 "Marital status"
la var v864 "Yearly income"
la var v866 "Sex of respondent"
la var v867 "Age of respondent"
gen num=_n
gen union=v753
recode union 5=0 0=.
gen age=v867
recode age 0=. 
gen birthyear=1969-age
gen born_os=v774
recode born_os 1/8=1
la var born_os "Born overseas"
gen female=v866
recode female 1=0 2=1 *=.
gen married=v823
recode married 2=1 0=. .=. *=0
gen divorced=v823
recode divorced 3/4=1 0=. .=. *=0
la var divorced "Divorced or separated"
gen hincome=v864
recode hincome 0=. 9=. 1=375 2=1000 3=1750 4=2750 5=3750 6=4750 7=5750 8=6750
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
recode v789 0=. 
gen ed_diploma=v789
recode ed_diploma 6/7=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=v789
recode ed_college 8=1 .=. *=0
gen ed_hsdropout=v789
recode ed_hsdropout 1/4=1 .=. *=0
gen ed_hsonly=v789
recode ed_hsonly 5=1 .=. *=0
* Voting (WITH preferences)
gen votealp=v655
recode votealp 2=1 1=0 3=0 *=.
gen votealp_2pp=v655
recode votealp_2pp 2=1 1=0 3=0 *=.
replace votealp_2pp=1 if v656==2 & votealp_2pp==.
replace votealp_2pp=0 if v656==1 & votealp_2pp==.
replace votealp_2pp=0 if v656==3 & votealp_2pp==.
gen votealp_previous=v647
recode votealp_previous 2=1 1=0 3=0 *=.
gen election=1969
keep election age birthyear born_os female married divorced ed_* votealp* hincom* union
gen survey=1969
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1969.dta", replace

*********
* AES 1967 survey (for 1966 election)
* No 2nd preference vote
* Includes income
*********
use "C:\Documents and Settings\Andrew Leigh\Datasets\Australian Election Studies\AES1967\aes_1967.dta", clear
gen union=v253
recode union 5=0 0=.
gen age=v285
recode age 0=. 
gen birthyear=1967-age
gen born_os=v272
recode born_os 1/5=0 6/8=1 0=.
la var born_os "Born overseas"
gen female=v286
recode female 1=0 2=1 *=.
gen married=v287
recode married 2=1 0=. .=. *=0
gen divorced=v287
recode divorced 3/4=1 0=. .=. *=0
la var divorced "Divorced or separated"
gen hincome=v324
recode hincome 0=. 9=. 1=375 2=1000 3=1750 4=2750 5=3750 6=4750 7=5750 8=6750
xtile hincome5=hincome, nq(5)
xtile hincome10=hincome, nq(10)
recode v251 0=. 9=.
gen ed_diploma=v251
recode ed_diploma 6/7=1 .=. *=0
la var ed_diploma "Diploma/trade qualification"
gen ed_college=v251
recode ed_college 8=1 .=. *=0
gen ed_hsdropout=v251
recode ed_hsdropout 1/4=1 .=. *=0
gen ed_hsonly=v251
recode ed_hsonly 5=1 .=. *=0
* Voting (WITHOUT preferences)
gen votealp=v159
recode votealp 2=1 1=0 3=0 *=.
gen votealp_previous=.
gen election=1966
keep election age birthyear born_os female married divorced ed_* votealp* hincom* union
gen survey=1966
sort survey
save "C:\Documents and Settings\Andrew Leigh\My publications\Aust - partisan voting\temp1966.dta", replace
