clear
set more off
cd "C:\Documents and Settings\Andrew Leigh\My publications\Aust - forecasting elections 2004\Economic Models\"

* JACKMAN & MARKS, JACKMAN
use "Jackman and Marks - updated to 2004", clear
reg voteinc dunemp pi if year<=1993, r
outreg using table2.doc, coefastr bracket 3aster replace bdec(3) se ct("Jackman & Marks - Replication") ti("Table 2: Election forecasting equations") 
reg voteinc dunemp pi if year<=1998, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman & Marks - Update to 1998")
reg voteinc dunemp pi if year<=2001, r
predict v_jacmar
predict se_jacmar, stdf
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman & Marks - Update to 2001")
reg voteinc dunemp pi, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman & Marks - Update to 2004")

reg voteinc dunemp pi honey if year<=1993, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman - Replication")
reg voteinc dunemp pi honey if year<=1998, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman - Update to 1998")
reg voteinc dunemp pi honey if year<=2001, r
predict v_jackman
predict se_jackman, stdf
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman - Update to 2001")
reg voteinc dunemp pi honey, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman - Update to 2004")

* For Data Appendix
*list year voteinc dunemp pi honey if e(sample)

* Pre-election predictions (note that this uses inflation and unemp figures from the quarter before the election)
for any jacmar jackman : replace v_X=v_X/100 \ replace se_X=se_X/100 \ gen t_X=(.5-v_X)/se_X \ gen pc_X=ttail(22,t_X) \ drop t_X
for num 0 -3 -12: sum v_jacmar pc_jacmar v_jackman pc_jackman if month==X

* CAMERON & CROSBY
cd "C:\Documents and Settings\Andrew Leigh\My publications\Aust - forecasting elections 2004\Economic Models\"
use "Cameron and Crosby - updated to 2004", clear
* Before doing predictions, we have to set the June 2004 honeymoon dummy to zero, since it's missing for non-election observations
replace honey=0 if dates==104.5 | dates==104.25 | dates==103.75
* Note that there are lots of variables in this dataset. The only economic variables we use are nunemp nrealw ngdp ninfln.
* For the election quarter, the RBA has released inflation and unemp numbers, but not GDP or real wages, so we need to assume that GDP and real wages were the same in Q4 2004 as in Q3 2004.
sort dates
gen n=_n
tsset n
for any nrealw ngdp: replace X=l.X if dates==104.75

* Summary statistics for the relevant variables
sum voteinc nunemp ninfln ngdp nrealw honey d1931 d1975 ww1 ww2 elect3

* Note: Cameron & Crosby have 5 dummies: 1906, 1931, 1975, WW1, WW2.
reg voteinc nunemp ninfln ngdp nrealw honey d1931 d1975 ww1 ww2 elect3 if dates<=96, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Cameron - Replication")
reg voteinc nunemp ninfln ngdp nrealw honey d1931 d1975 ww1 ww2 elect3 if dates<=98.75, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Cameron - Update to 1998")
reg voteinc nunemp ninfln ngdp nrealw honey d1931 d1975 ww1 ww2 elect3 if dates<=101.75, r
predict v_cameron
predict se_cameron, stdf
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Cameron - Update to 2001")
reg voteinc nunemp ninfln ngdp nrealw honey d1931 d1975 ww1 ww2 elect3, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Cameron - Update to 2004")

* For Data Appendix
*replace year=year+1900
*list year voteinc nunemp ninfln ngdp nrealw honey if e(sample)
*list year d1931 d1975 ww1 ww2 elect3 if e(sample)

* Pre-election predictions
for any cameron: replace v_X=v_X/100 \ replace se_X=se_X/100 \ gen t_X=(.5-v_X)/se_X \ gen pc_X=ttail(40,t_X) \ drop t_X
for num 104.5 104.25 103.75: sum v_cameron pc_cameron if dates==X

* THIS SECTION IS FOR YOUR PARTISAN VOTING PAPER
gen laborincumbent=1 if votel==voteinc
recode laborincumbent .=0
reg voteinc nunemp ninfln ngdp nrealw honey d1931 d1975 ww1 ww2 elect3 if dates<=101.75, r
outreg using table_partisanvoting.doc, coefastr bracket 3aster replace bdec(3) se ct("Cameron - voteinc")
reg voteinc nunemp ninfln if dates<=101.75, r
outreg using table_partisanvoting.doc, coefastr bracket 3aster append bdec(3) se ct("Simple - voteinc")
reg votel nunemp ninfln ngdp nrealw honey laborincumbent d1931 d1975 ww1 ww2 elect3 if dates<=101.75, r
outreg using table_partisanvoting.doc, coefastr bracket 3aster append bdec(3) se ct("Cameron - vote Labor")
reg votel nunemp ninfln laborincumbent if dates<=101.75, r
outreg using table_partisanvoting.doc, coefastr bracket 3aster append bdec(3) se ct("Simple - vote Labor")

* TESTING THE MODELS ON US DATA
cd "C:\Documents and Settings\Andrew Leigh\My publications\Aust - forecasting elections 2004\Economic Models\"
use us_data, clear
gen honey=1 if duration==0
recode honey .=0
gen ww1=1 if year==1916
gen ww2=1 if year==1940 | year==1944
for num 1/2: recode wwX .=0
reg vote dunemp infl, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman & Marks - US data")
reg vote dunemp infl honey, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Jackman - US data")
reg vote unemp infl drgdp drealw honey ww1 ww2, r
outreg using table2.doc, coefastr bracket 3aster append bdec(3) se ct("Cameron - US data")

* For Data Appendix
list year vote unemp dunemp infl drgdp drealw honey if e(sample)




