* The this Stata dofile and the accompanying dataset produces the results in Andrew Leigh & Christine Neill, 
* 'Do Gun Buybacks Save Lives? Evidence from Panel Data' (2010) American Law and Economics Review. 
* Feel free to replicate or adapt our dataset, so long as you also cite that paper. 
* Questions should be directed to cneill@wlu.ca.

version 8.0
 

cap log close
adopath + "E:\ado"
cd "E:\Guns"
log using "results\regressiong.log", replace
set more off





use guns_panel_dataset.dta, clear

gen accund = acc+und

for any suicide homicide accund: gen nfX = (X - fX)

******************************************************

for any suicide fsuicide nfsuicide homicide fhomicide nfhomicide faccund nfaccund accund acc und acc1 undet1 illdef gunsbought: replace X = ((X/pop)*100000)

*********************************************************



for any fsuicide nfsuicide suicide fhomicide nfhomicide homicide faccund nfaccund accund acc1 undet1 illdef : bysort state: egen temp1=mean(X) if year>=1990 & year<=1995 \ bysort state: egen temp2=max(temp1) \ bysort state: egen temp3=mean(X) if year>=1998 & year<=2003 \ bysort state: egen temp4=max(temp3) \ gen d_X=temp4-temp2 \ drop temp*
*for any fsuicide nfsuicide suicide fhomicide nfhomicide homicide faccund nfaccund accund acc1 undet1 illdef : bysort state: egen temp1=mean(X) if year>=1990 & year<=1995 \ bysort state: egen temp2=max(temp1) \ bysort state: egen temp3=mean(X) if year>=1998 & year<=2006 \ bysort state: egen temp4=max(temp3) \ gen d_X=temp4-temp2 \ drop temp*

** Figures 
tw scatter d_fsuicide gunsbought if year==2001,mlabel(state3) || lfit d_fsuicide gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in firearm suicides per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_fsuicide.gph", replace
tw scatter d_fhomicide gunsbought if year==2001,mlabel(state3) || lfit d_fhomicide gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in firearm homicides per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_fhomicide.gph", replace
tw scatter d_faccund gunsbought if year==2001,mlabel(state3) || lfit d_faccund gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in firearm accidents/undet per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_faccund.gph", replace
tw scatter d_nfsuicide gunsbought if year==2001,mlabel(state3) || lfit d_nfsuicide gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in non-firearm suicides per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_nfsuicide.gph", replace
tw scatter d_nfhomicide gunsbought if year==2001,mlabel(state3) || lfit d_nfhomicide gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in non-firearm homicides per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_nfhomicide.gph", replace
tw scatter d_nfaccund gunsbought if year==2001,mlabel(state3) || lfit d_nfaccund gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in non-firearm accidents/undet per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_nfaccund.gph", replace
tw scatter d_suicide gunsbought if year==2001,mlabel(state3) || lfit d_suicide gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in overall suicides per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_suicide.gph", replace
tw scatter d_homicide gunsbought if year==2001,mlabel(state3) || lfit d_homicide gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in overall homicides per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_homicide.gph", replace
tw scatter d_accund gunsbought if year==2001,mlabel(state3) || lfit d_accund gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Change in accidents/undet per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_accund.gph", replace

tw scatter d_illdef gunsbought if year==2001,mlabel(state3) || lfit d_illdef gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Ill defined deaths per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_illdef.gph", replace
tw scatter d_acc1 gunsbought if year==2001,mlabel(state3) || lfit d_acc1 gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Accidental deaths1 per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_acc1.gph", replace
tw scatter d_undet1 gunsbought if year==2001,mlabel(state3) || lfit d_undet1 gunsbought if year==2001, xti("Guns bought back per 100,000 (Mouzos)") yti("Deaths of undet cause1 per 100,000" "1990-95 vs 1998-2003") legend(off)
graph save "results\ch_undet1.gph", replace


**********************************************

gen temp=gun_ownership if year==1989 | year==1992
bysort state: egen guns1989_1992=mean(temp)
drop temp

egen gg = max(guns1989_1992) if stateno==2
egen gg2 = max(gg)
replace guns1989_1992 = gg2 if stateno==1
drop gg gg2

**********************************************

* Graphing the first stage
tw scatter gunsbought guns1989_1992 if year==2001, mlabel(state3)|| lfit  gunsbought guns1989_1992 if year==2001, xti("Guns per 100,000 (1989-1992)") yti("Guns bought back per 100,000 (Mouzos)") legend(off)
graph save "results\bought_owned.gph", replace


gen fss = fsuicide/suicide


**********************************************
** Table 3
** correlations between gunsbought, gun ownership and FSS
reg gunsbought guns1989_1992 if year==1997
reg gunsbought fss if year==1997
reg gunsbought guns1989_1992 fss if year==1997
reg guns1989_1992 fss if year==1990




**********************************************
**  Table 4
for any fsuicide fhomicide faccund nfsuicide nfhomicide nfaccund suicide homicide accund illdef acc1 undet1  : reg d_X gunsbought if year==2001
for any fsuicide fhomicide faccund nfsuicide nfhomicide nfaccund suicide homicide accund: ivreg d_X (gunsbought=guns1989_1992) if year==2001, first


*********************************************
** Table 6
** Estimated correlation between buyback rate and prior trends in death rates
gen gunsbought96 = gunsbought if year==1996
by state: egen gbb96 = max(gunsbought96)
gen gbb96y = gbb96*year/1000

	
for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gbb96y i.year i.stateno if year<=1995, cluster(stateno)\ outreg using "results\t6X.out", replace bdec(5 3)  coefastr 3aster 


**********************************************
**  Appendix Table 3
for any faccund nfaccund accund illdef acc1 undet1  : reg d_X gunsbought if year==2001\ outreg using "results\AT3X.out", replace bdec(5 3)  coefastr 3aster rdec(4)


*********************************************


replace gunsbought=0 if year<=1996

for any fsuicide fhomicide homicide suicide: xi: xtreg X gunsbought i.year , fe i(stateno)  

for any fsuicide fhomicide homicide suicide: xi: xtreg X gun_ownership i.year , fe i(stateno)  
tsset stateno year
replace gun_ownership=l.gun_ownership if gun_ownership==.
for any fsuicide fhomicide homicide suicide: xi: xtreg X gun_ownership i.year, fe i(stateno)   
for any fsuicide fhomicide homicide suicide: xi: areg X gun_ownership i.year [aw=pop], a(stateno)  

la var fsuicide "Firearm suicides per 100,000"
la var gun_ownership "Gun ownership rate (%)"

set scheme s1mono
for any Vic NSW ACT Tas NT WA SA Qld: tw line fsuicide year if year>=1989 & state3=="X", yaxis(1) yti("")  || line gun_ownership year if year>=1989 & state3=="X", yaxis(2)  xti("") yti("", axis(2)) ti("X") name(X, replace) nodraw legend(off)
gr combine Vic NSW ACT Tas NT WA SA Qld, note("Firearm suicides per 100,000 (left scale, dashed line)." "Gun ownership rate in % (right scale, solid line).") ycommon
graph save "results\ownership1.gph", replace

gen portarthur=1 if year==1996 & state3=="Tas"
for any Vic NSW ACT Tas NT WA SA Qld: tw line fhomicide year if year>=1989 & state3=="X" & portarthur~=1,yaxis(1) yti("") || line gun_ownership year if year>=1989 & state3=="X", yaxis(2)  xti("") yti("", axis(2)) ti("X") name(X, replace) nodraw legend(off)
gr combine Vic NSW ACT Tas NT WA SA Qld, note("Firearm homicides per 100,000 (left scale, dashed line)." "Gun ownership rate in % (right scale, solid line)." "Graphs do not show Tasmania in 1996.") ycommon
graph save "results\ownership2.gph", replace

*****************
** simple regressions **
*****************


** Modify measurement - now death is per million, firearm buybacks are per 1000 (just a leading zeros fix)

	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide faccund nfaccund accund acc1 undet1 acc und: replace X = X*10
	replace gunsbought = gunsbought/100

** Shorter period (1987)
    *  drop if year<1987



************************
** Table 5
** basic specs, not population weighted, clustered at state level, all years **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno, cluster(stateno)\ outreg using "results\t5X.out", replace bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year, cluster(stateno)\ outreg using "results\t5X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno, cluster(stateno)\ outreg using "results\t5X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno*year, cluster(stateno)\ outreg using "results\t5X.out", append bdec(5 3)  coefastr 3aster rdec(4)



************************
** Table 7 - allowing for state-specific linear trends, and a break in state-specific trends in 1988 
gen post88trend = (year>1988)*year

** not population weighted, clustered at state level, all years **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*post88trend , cluster(stateno)\ outreg using "results\t7X.out", replace bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year i.stateno*post88trend, cluster(stateno)\ outreg using "results\t7X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno*post88trend, cluster(stateno)\ outreg using "results\t7X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno*year i.stateno*post88trend, cluster(stateno)\ outreg using "results\t7X.out", append bdec(5 3)  coefastr 3aster rdec(4)


************************

** Table 8 - Dynamics **
gen y2 = year== 1997|year==1998|year==1999
gen y3 = year== 2000|year==2001|year==2002
gen y4 = year== 2003|year==2004|year==2005|year==2006
gen y2gbb = y2*gunsbought
gen y3gbb = y3*gunsbought
gen y4gbb = y4*gunsbought

	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X y2gbb y3gbb y4gbb i.year i.stateno  , cluster(stateno)\ outreg using "results\t8X.out", replace bdec(3 3 3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X y2gbb y3gbb y4gbb i.year i.stateno*year  , cluster(stateno)\ outreg using "results\t8X.out", append bdec(3 3 3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X y2gbb y3gbb y4gbb urate city p2024 pgt65 i.year i.stateno  , cluster(stateno)\ outreg using "results\t8X.out", append bdec(3 3 3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X y2gbb y3gbb y4gbb urate city p2024 pgt65 i.year i.stateno*year  , cluster(stateno)\ outreg using "results\t8X.out", append bdec(3 3 3 3)  coefastr 3aster rdec(4)


***********************************

** TABLE 9:  Port Arthur dummy **

gen padummy = year==1996 & stateno==6

	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno padummy , cluster(stateno)\ outreg using "results\t9X.out", replace bdec(3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year padummy , cluster(stateno)\ outreg using "results\t9X.out", append bdec(3 3)  coefastr 3aster rdec(4)

** Excluding 1997 **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno if  year~=1997, cluster(stateno)\ outreg using "results\t9aX.out", replace bdec(3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year if year~=1997, cluster(stateno)\ outreg using "results\t9aX.out", append bdec(3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno if year~=1997, cluster(stateno)\ outreg using "results\t9aX.out", append bdec(3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno*year if year~=1997, cluster(stateno)\ outreg using "results\t9aX.out", append bdec(3 3)  coefastr 3aster rdec(4)

** Both;
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno padummy if  year~=1997, cluster(stateno)\ outreg using "results\t9bX.out", replace bdec(3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year padummy if year~=1997, cluster(stateno)\ outreg using "results\t9bX.out", append bdec(3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 padummy i.year i.stateno if year~=1997, cluster(stateno)\ outreg using "results\t9bX.out", append bdec(3 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 padummy i.year i.stateno*year if year~=1997, cluster(stateno)\ outreg using "results\t9bX.out", append bdec(3 3)  coefastr 3aster rdec(4)

***********************************
** TABLE 10:  Tobit vs OLS  **
	for any fhomicide nfhomicide homicide: xi: tobit X gunsbought i.year i.stateno padummy, ll(0) \ outreg using "results\table10X.out", replace bdec(3 3) coefastr 3aster rdec(4)
	for any fhomicide nfhomicide homicide: xi: reg X gunsbought i.year i.stateno padummy, \ outreg using "results\table10X.out", append bdec(3 3) coefastr 3aster rdec(4)




***********************************
** TABLE 11:  ivregs **
replace guns1989_1992 = 0 if year<1997

	for any fsuicide nfsuicide suicide : xi: ivreg X (gunsbought =guns1989_1992) i.year i.stateno , cluster(stateno)\ outreg using "results\t11X.out", replace bdec(3 3) coefastr 3aster rdec(4)
	for any fsuicide nfsuicide suicide : xi: ivreg X (gunsbought =guns1989_1992) i.year i.stateno*year , cluster(stateno)\ outreg using "results\t11X.out", append bdec(3 3) coefastr 3aster  rdec(4)
	for any fsuicide nfsuicide suicide : xi: ivreg X (gunsbought =guns1989_1992) i.year i.stateno  padummy , cluster(stateno)\ outreg using "results\t11X.out", append bdec(3 3) coefastr 3aster rdec(4)
	for any fsuicide nfsuicide suicide : xi: ivreg X (gunsbought =guns1989_1992) i.year i.stateno*year  padummy , cluster(stateno)\ outreg using "results\t11X.out", append bdec(3 3) coefastr 3aster rdec(4)


gen fssiv = fss if year==1995
bysort stateno: egen fssiv2 = max(fssiv)
replace fssiv = fssiv2 if year>=1997
replace fssiv = 0 if year<1997

	for any fhomicide nfhomicide homicide : xi: ivreg X (gunsbought =fssiv guns1989_1992) i.year i.stateno , cluster(stateno)\ outreg using "results\t10aX.out", replace bdec(3 3) coefastr 3aster rdec(4)
	for any fhomicide nfhomicide homicide : xi: ivreg X (gunsbought =fssiv guns1989_1992) i.year i.stateno*year  , cluster(stateno)\ outreg using "results\t10aX.out", append bdec(3 3) coefastr 3aster rdec(4)
	for any fhomicide nfhomicide homicide : xi: ivreg X (gunsbought =fssiv guns1989_1992) i.year i.stateno padummy  , cluster(stateno)\ outreg using "results\t10aX.out", append bdec(3 3) coefastr 3aster rdec(4)
	for any fhomicide nfhomicide homicide : xi: ivreg X (gunsbought =fssiv guns1989_1992) i.year i.stateno*year padummy  , cluster(stateno)\ outreg using "results\t10aX.out", append bdec(3 3) coefastr 3aster rdec(4)

*********************************************************

*********************************************************
** Checking detailed regs for accidental and undetermined deaths
** Table 5a
** basic specs, not population weighted, clustered at state level, all years **
	for any faccund nfaccund accund : xi: reg X gunsbought i.year i.stateno, cluster(stateno)\ outreg using "results\t5aX.out", replace bdec(5 3)  coefastr 3aster rdec(4)
	for any faccund nfaccund accund : xi: reg X gunsbought i.year i.stateno*year, cluster(stateno)\ outreg using "results\t5aX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any faccund nfaccund accund : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno, cluster(stateno)\ outreg using "results\t5aX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any faccund nfaccund accund : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno*year, cluster(stateno)\ outreg using "results\t5aX.out", append bdec(5 3)  coefastr 3aster rdec(4)

** Table 5b
** basic specs, not population weighted, clustered at state level, all years **
	for any acc undet acc1 undet1 accund : xi: reg X gunsbought i.year i.stateno, cluster(stateno)\ outreg using "results\t5bX.out", replace bdec(5 3)  coefastr 3aster rdec(4)
	for any acc undet acc1 undet1 accund: xi: reg X gunsbought i.year i.stateno*year, cluster(stateno)\ outreg using "results\t5bX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any acc undet acc1 undet1 accund: xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno, cluster(stateno)\ outreg using "results\t5bX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any acc undet acc1 undet1 accund: xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno*year, cluster(stateno)\ outreg using "results\t5bX.out", append bdec(5 3)  coefastr 3aster rdec(4)


*********************************************************
** Other checks

** excluding ACT and NT **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno if stateno~=1 & stateno~=3 , cluster(stateno)\ outreg using "results\tb.out", replace bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year if stateno~=1 & stateno~=3, cluster(stateno)\ outreg using "results\tb.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65  i.year i.stateno if stateno~=1 & stateno~=3, cluster(stateno)\ outreg using "results\tb.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65  i.year i.stateno*year if stateno~=1 & stateno~=3, cluster(stateno)\ outreg using "results\tb.out", append bdec(5 3)  coefastr 3aster rdec(4)

** Only after 1979 **
preserve
drop if year<1979
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought , cluster(stateno)\ outreg using "results\tcX.out", replace bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year , cluster(stateno) \ outreg using "results\tcX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno , cluster(stateno)\ outreg using "results\tcX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year  , cluster(stateno)\ outreg using "results\tcX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65  i.year i.stateno  , cluster(stateno)\ outreg using "results\tcX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65  i.year i.stateno*year  , cluster(stateno)\ outreg using "results\tcX.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 pol pris  i.year i.stateno*year  , cluster(stateno)\ outreg using "results\tcX.out", append bdec(5 3)  coefastr 3aster rdec(4)

restore


************************
** Appendix Table 1 - allowing for police etc to be included

** Baseline **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno, cluster(stateno)\ outreg using "results\AT1X.out", replace bdec(5 3)  coefastr 3aster rdec(4)

** % male **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 pm1524 i.year i.stateno , cluster(stateno)\ outreg using "results\AT1X.out", append bdec(5 3)  coefastr 3aster rdec(4)


** police and prisoners **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno if state~="ACT" & year<=2005 & year>=1976, cluster(stateno)\ outreg using "results\AT1X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 pol pris i.year i.stateno , cluster(stateno)\ outreg using "results\AT1X.out", append bdec(5 3)  coefastr 3aster rdec(4)

** indigenous **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno i.stateno if year>=1991, cluster(stateno)\ outreg using "results\AT1X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 indig i.year i.stateno i.stateno, cluster(stateno)\ outreg using "results\AT1X.out", append bdec(5 3)  coefastr 3aster rdec(4)



************************
** Appendix Table 2 - allowing for start in 1988

preserve
keep if year>=1988


** not population weighted, clustered at state level, all years **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno, cluster(stateno)\ outreg using "results\AT2X.out", replace bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year i.stateno, cluster(stateno)\ outreg using "results\AT2X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno, cluster(stateno)\ outreg using "results\AT2X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno*year i.stateno, cluster(stateno)\ outreg using "results\AT2X.out", append bdec(5 3)  coefastr 3aster rdec(4)

restore

************************
** Appendix Table 4 -quadratic trends

gen year2 = year^2

** basic specs, not population weighted, clustered at state level, all years **
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year , cluster(stateno)\ outreg using "results\AT4X.out", replace bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought i.year i.stateno*year i.stateno*year2, cluster(stateno)\ outreg using "results\AT4X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year  i.stateno*year, cluster(stateno)\ outreg using "results\AT4X.out", append bdec(5 3)  coefastr 3aster rdec(4)
	for any fsuicide fhomicide nfsuicide nfhomicide suicide homicide : xi: reg X gunsbought urate city p2024 pgt65 i.year i.stateno*year i.stateno*year2, cluster(stateno)\ outreg using "results\AT4X.out", append bdec(5 3)  coefastr 3aster rdec(4)



************************

