clear
set more off
cd "C:\Documents and Settings\Andrew Leigh\My publications\Health & Inequality\"
set mem 5m
set matsize 400
use healthtopinc_web.dta, clear

* Figures 2, 3, 4, 7, 8
set scheme s1mono
for any australia canada france germany ireland netherlands nz spain sweden switzerland uk us \ any Australia Canada France Germany Ireland Netherlands "New Zealand" Spain Sweden Switzerland UK US: la var X10 "Y" \ gen X_lifex=X_le_total \ gen X_lnim=ln(X_im) \ la var X_lnim "Y" \ la var X_lifex "Y" \ \ gen X_lnhom=ln(X_hom) \ la var X_lnhom "Y" \ gen X_lnsui=ln(X_sui) \ la var X_lnsui "Y"
for any australia canada france germany ireland netherlands nz spain sweden switzerland uk us \ num 1942 1941 1905 1961 1939 1914 1925 1981 1903 1933 1919 1917: replace X_lifex=. if year<Y \ replace X_lnim=. if year<Y \ replace X_lnhom=. if year<Y \ replace X_lnsui=. if year<Y
twoway connected australia10 canada10 france10 germany10 ireland10 netherlands10 nz10 spain10 sweden10 switzerland10 uk10 us10 year if year>1900, ti("Figure 2: Income share of richest 10%")
twoway connected australia_lifex canada_lifex france_lifex germany_lifex ireland_lifex netherlands_lifex nz_lifex spain_lifex sweden_lifex switzerland_lifex uk_lifex us_lifex year if year>1900, ti("Figure 3: Life expectancy at birth") 
twoway connected australia_lnim canada_lnim france_lnim germany_lnim ireland_lnim netherlands_lnim nz_lnim spain_lnim sweden_lnim switzerland_lnim uk_lnim us_lnim year if year>1900, ti("Figure 4: Log infant mortality rate (per 1000 births)")
twoway connected australia_lnhom canada_lnhom france_lnhom germany_lnhom ireland_lnhom netherlands_lnhom nz_lnhom spain_lnhom sweden_lnhom switzerland_lnhom uk_lnhom us_lnhom year if year>1949, ti("Figure 7: Log homicide rate (per 100,000 people)")
twoway connected australia_lnsui canada_lnsui france_lnsui germany_lnsui ireland_lnsui netherlands_lnsui nz_lnsui spain_lnsui sweden_lnsui switzerland_lnsui uk_lnsui us_lnsui year if year>1949, ti("Figure 8: Log suicide rate (per 100,000 people)")
drop *_lnim *_lnsui *_lnhom *_lifex

for any australia canada germany nz uk us netherlands france spain sweden switzerland ireland: ren X_homicide homX \ ren X_suicide suiX \ ren X_im imX \ ren X_educ educX \ ren X_phealth phealthX \ ren X_thealth thealthX \ ren Xgdp gdpX \ ren X10 share10X \ ren X_le_total le_totalX 
ren us_cpi cpi
keep hom* sui* im* share10* le_* gdp* educ* phealth* thealth* year cpi
reshape long hom sui im share10 le_total gdp educ phealth thealth, i(year) j(cty) string
gen ctyno=.
for any australia canada france germany ireland netherlands nz spain sweden switzerland uk us \ num 1/12: replace ctyno=Y if cty=="X"

* Interpolating life expectancy, infant mortality, health & education control variables
gen lnim=ln(im)
for num 1/12: ipolate im year if ctyno==X, gen(tempim) \ replace lnim=ln(tempim) if ctyno==X \ ipolate le_total year if ctyno==X, gen(temple) \ replace le_total=temple if ctyno==X \ ipolate educ year if ctyno==X & year>=1960, gen(tempeduc) epolate \ replace educ=tempeduc if ctyno==X \ ipolate phealth year if ctyno==X & year>=1960, gen(tempphealth) epolate \ replace phealth=tempphealth if ctyno==X \ ipolate thealth year if ctyno==X & year>=1960, gen(tempthealth) epolate \ replace thealth=tempthealth if ctyno==X \ ipolate hom year if ctyno==X, gen(temphom) \ replace hom=temphom if ctyno==X \ ipolate gdp year if ctyno==X & year>=2000, gen(tempgdp) epolate \ replace gdp=tempgdp if ctyno==X & gdp==. \ ipolate sui year if ctyno==X , gen(tempsui) \ replace sui=tempsui if ctyno==X \ drop temp*
for any hom sui: replace X=. if year<1950
for any hom sui: replace X=ln(X)
replace thealth=thealth-phealth
for var phealth thealth: replace X=ln(X/cpi)
sum phealth thealth, d
gen lngdp=ln(gdp)
replace gdp=gdp/1000
gen gdpsq=gdp^2
la var gdp "Real GDP per capita ($1000s)"
la var gdpsq "Real GDP per capita squared ($1000s)"
la var le_total "Life expectancy at birth"
la var phealth "Log real public health spending per capita"
la var thealth "Log real private health spending per capita"
la var im "Infant mortality rate (per 1000 births)"
la var lnim "Log infant mortality rate per 1000 births"
la var hom "Log homicide rate per 100,000 people"
la var sui "Log suicide rate per 100,000 people"
la var share10 "Income share of richest 10%"
drop if year<1895 | ctyno==.

tsset ctyno year
* Creating differences
for any lnim le_total share10 gdp educ phealth thealth: gen diff1X=s1.X \ gen diff5X=s5.X \ gen diff10X=s10.X \ gen diff20X=s10.X+s10.diff10X 
for any lnim le_total phealth thealth: gen lag1X=l1.X \ gen lag5X=l5.X \ gen lag10X=l10.X \ gen lag20X=l20.X \ gen lag2X=l2.X \ gen lag6X=l6.X \ gen lag11X=l11.X \ gen lag21X=l21.X 

* Figures 5 & 6
gen country="."
for any australia canada france germany ireland netherlands nz spain sweden switzerland uk us \ any Australia Canada France Germany Ireland Netherlands "New Zealand" Spain Sweden Switzerland UK US: replace country="Y" if cty=="X" 
for any le_total lnim: reg X share10 if year==1996 \ predict predX if year==1996
set scheme s1mono
twoway scatter le_total share10 if year==1996, mlabel(country) || line predle_total share10 if year==1996, ti("Figure 5: Top Incomes and Life Expectancy (1996)") legend(off) ytitle("Life expectancy at birth")
twoway scatter lnim share10 if year==1996, mlabel(country) || line predlnim share10 if year==1996, ti("Figure 6: Top Incomes and Infant Mortality (1996)") legend(off) ytitle("Log infant mortality rate per 1000 births")

* Summary statistics, and relationships between key variables
tsset ctyno year
xi: areg le_total share10 gdp i.ctyno, r cl(ctyno) a(year) 
tabstat share10 le_total lnim hom sui gdp educ phealth thealth if e(sample), statistics(mean sd n) column(statistics)
bysort cty: list year if e(sample)
bysort cty: sum year if e(sample)
*xi: areg share10 share1 i.ctyno if e(sample), r a(year)
xi: areg le_total lnim i.ctyno if e(sample), r a(year)
reg le_total lnim if e(sample), r

* Levels, with and without fixed effects
for any le_total: xi: reg X share10 gdp, r cl(ctyno) \ outreg using table2-fe.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("No FE - X")
for any lnim: xi: reg X share10 gdp, r cl(ctyno) \ outreg using table2-fe.doc, coefastr nocons bracket 3aster append bdec(3) se ct("No FE - X")
for any le_total lnim: xi: reg X share10 gdp i.ctyno, r cl(ctyno) \ testparm _Ictyno* \ outreg using table2-fe.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Cty FE - X")
for any le_total lnim: xi: reg X share10 gdp i.year, r cl(ctyno) \ testparm _Iyear* \ outreg using table2-fe.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Yr FE - X")
for any le_total lnim: xi: reg X share10 gdp i.year i.ctyno, r cl(ctyno) \ testparm _Iyear* \ testparm _Ictyno* \ outreg using table2-fe.doc, coefastr nocons bracket 3aster append bdec(3) se ct("Cty & Yr FE: X")

* Levels, with FE
for any le_total: xi: areg X share10 gdp i.ctyno, r cl(ctyno) a(year) \ outreg using table3.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("X")
for any lnim: xi: areg X share10 gdp i.ctyno, r cl(ctyno) a(year) \ outreg using table3.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for any le_total lnim: xi: areg X share10 gdp gdpsq i.ctyno, r cl(ctyno) a(year) \ outreg using table3.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for any le_total lnim: xi: areg X share10 gdp gdpsq educ phealth thealth i.ctyno, r cl(ctyno) a(year) \ xi: areg X share10 gdp gdpsq i.ctyno if e(sample), r cl(ctyno) a(year) \ outreg using table3.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for any le_total lnim: xi: areg X share10 gdp gdpsq educ phealth thealth i.ctyno, r cl(ctyno) a(year) \ outreg using table3.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")

* Checking 95% confidence intervals (for Conclusion)
for any le_total lnim: xi: areg X share10 gdp gdpsq i.ctyno, r cl(ctyno) a(year)
sum lnim if e(sample)
di exp(2.878)
di exp(2.878+.0095)
sum share10 if cty=="us" & year==2001
sum share10 if cty=="sweden" & year==2001
sum share10 if cty=="sweden" & year==2003

* Comparing to Judge (1998)
for any im le s10: gen d_X=.
for X in num 1981 1981 1979 1983 1981 1979 1979 \ Y in num 1985 1987 1984 1987 1987 1986 1986 \ Z in any australia canada france netherlands sweden uk us: gen temp1=exp(lnim) if year==X \ bysort ctyno: egen temp2=max(temp1) \ replace d_im=exp(lnim)-temp2 if year==Y & cty=="Z" \ drop temp* \ gen temp1=le_total if year==X \ bysort ctyno: egen temp2=max(temp1) \ replace d_le=le_total-temp2 if year==Y & cty=="Z" \ drop temp* \ gen temp1=share10 if year==X \ bysort ctyno: egen temp2=max(temp1) \ replace d_s10=share10-temp2 if year==Y & cty=="Z" \ drop temp*
ci2 d_le d_s10, corr
ci2 d_im d_s10, corr

* In lags - 1 year, 5 year, 10 year
tsset ctyno year
for any le_total: xi: reg X l1.share10 l1.gdp i.ctyno i.year, r cl(ctyno) \ outreg using table_lags.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("X")
for any lnim: xi: reg X l1.share10 l1.gdp i.ctyno i.year, r cl(ctyno) \ outreg using table_lags.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for any le_total lnim: xi: reg X l1.share10 l2.share10 l1.gdp l2.gdp i.ctyno i.year, r cl(ctyno) \ outreg using table_lags.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") \ lincom l1.share10+l2.share10
for any le_total lnim: xi: reg X l1.share10 l2.share10 l3.share10 l4.share10 l5.share10 l1.gdp l2.gdp l3.gdp l4.gdp l5.gdp i.ctyno i.year, r cl(ctyno) \ outreg using table_lags.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") \ lincom l1.share10+l2.share10+l3.share10+l4.share10+l5.share10
for any le_total lnim: xi: reg X l1.share10 l1.gdp l1.gdpsq i.ctyno i.year, r cl(ctyno) \ outreg using table_lags.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X")
for any le_total lnim: xi: reg X l1.share10 l2.share10 l1.gdp l2.gdp l1.gdpsq l2.gdpsq i.ctyno i.year, r cl(ctyno) \ outreg using table_lags.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") \ lincom l1.share10+l2.share10
for any le_total lnim: xi: reg X l1.share10 l2.share10 l3.share10 l4.share10 l5.share10 l1.gdp l2.gdp l3.gdp l4.gdp l5.gdp l1.gdpsq l2.gdpsq l3.gdpsq l4.gdpsq l5.gdpsq i.ctyno i.year, r cl(ctyno) \ outreg using table_lags.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X") \ lincom l1.share10+ l2.share10+ l3.share10+ l4.share10+l5.share10

* Homicide, suicide 
for any hom: xi: areg X share10 gdp gdpsq i.ctyno, r cl(ctyno) a(year) \ outreg using table-homsui.doc, coefastr nocons bracket 3aster replace bdec(3) se ct("X: Levels")
for any sui: xi: areg X share10 gdp gdpsq i.ctyno, r cl(ctyno) a(year) \ outreg using table-homsui.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X: Levels")
for any hom sui: xi: reg X l1.share10 l1.gdp l1.gdpsq i.ctyno i.year, r cl(ctyno) \ outreg using table-homsui.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X: 1 yr diffs")
for any hom sui: xi: reg X l5.share10 l5.gdp l5.gdpsq i.ctyno i.year, r cl(ctyno) \ outreg using table-homsui.doc, coefastr nocons bracket 3aster append bdec(3) se ct("X: 5 yr diffs")
