*******************************************************************
* This dofile was written to accompany the article:
* Andrew Leigh, 'Earned Income Tax Credits and Labor Supply: New Evidence from a British Natural Experiment' (2007) National Tax Journal, 60(2): 205-224 
* Feel free to use or adapt it, so long as you cite that article. Questions to andrew_leigh@ksg02.harvard.edu.
* 
* The data file was downloaded from the UK Data Archive in 2004. However, at the time of posting
* this dofile on my website (May 2009), I noticed that the dataset had been withdrawn by the UKDA.
* For details, see the notes to SN5974 (the April 1999 - June 2000 dataset), which is the closest 
* dataset now available to the one I used (March 1999 to May 2000). I have zipped the description of SN5974 along with this dofile.
*
* If anyone wishes to exactly replicate my results, I am happy to share the original dataset (filename mm005qlg.dta)
* however you will need permission in writing from the UK Data Archive, as the conditions of use did not allow me to share it with others.
******************************************************************

clear
set more off
set mem 500m
set matsize 800
version 8

/*

**************************************************
* Using 5-quarter longitudinal panel
* from March 1999 to May 2000
**************************************************
clear
cd "<Active Directory>"
set mem 500m
use mm005qlg, clear

* Generating a unique household identifier (see p.2 of longitudinal.pdf, and p.425 of variabledetails.pdf)
sum quota week w1yr qrtr add hhld 
ren wavfnd1 wavfnd
gen hhid=quota*100000000000+week*1000000000+w1yr*100000000+qrtr*10000000+add*100000+wavfnd*10000+hhld*100

keep persid lgwt sex week age* marstt* ethcen* uresmc* relhfu* fdpch16* fdpch19* inecaca* wrking* ttushr* ttachr* bushr* sumhrs* hiqual* hourpay* grsswk* netwk* livtog* hhid limitk* lnglim*

for any uresmc marstt fdpch16 fdpch19 livtog: gen diff_X=1 if X1~=X2 | X1~=X3 | X1~=X4 | X1~=X5 \ recode diff_X .=0 \ la var diff_X "Changed X"

for X in any sex lgwt week hhid: for Y in num 1/5: gen XY=X
drop sex lgwt week hhid

reshape long hhid lgwt week sex age marstt ethcen uresmc relhfu fdpch16 fdpch19 inecaca wrking ttushr ttachr bushr sumhrs hiqual hourpay grsswk grsswk2 netwk netwk2 livtog limitk lnglim, i(persid) j(wave 1-5)
drop if wave==3

recode lnglim 2=0
recode limitk 2=0 .=0

bysort hhid wave: egen hhsize=count(persid)
sum hhsize,d

gen refdte=.
for num 1 2 4 5 \ num 19990300 19990600 19991200 20000300: replace refdte=Y if wave==X
gen month=int(week/4)
replace refdte=refdte+month*100

gen cpi=.
for num 19970100 19970200 19970300 19970400 19970500 19970600 19970700 19970800 19970900 19971000 19971100 19971200 19980100 19980200 19980300 19980400 19980500 19980600 19980700 19980800 19980900 19981000 19981100 19981200 19990100 19990200 19990300 19990400 19990500 19990600 19990700 19990800 19990900 19991000 \ num 0.889 0.893 0.895 0.900 0.904 0.907 0.907 0.913 0.918 0.919 0.919 0.922 0.919 0.923 0.926 0.937 0.942 0.941 0.939 0.943 0.947 0.948 0.947 0.947 0.941 0.943 0.945 0.952 0.954 0.954 0.951 0.953 0.957 0.959: replace cpi=Y if refdte>=X & refdte<(X+35)

for num 19991100 19991200 20000100 20000200 20000300 20000400 20000500 20000600 20000700 20000800 20000900 20001000 20001100 20001200 20010100 20010200 20010300 20010400 20010500 20010600 20010700 20010800 20010900 20011000 20011100 \ num 0.960 0.964 0.960 0.965 0.970 0.980 0.983 0.986 0.982 0.982 0.989 0.988 0.991 0.992 0.986 0.991 0.992 0.997 1.003 1.005 0.998 1.002 1.006 1.004 1.000: replace cpi=Y if refdte>=X & refdte<(X+35)
label var cpi "Retail Price Index (RPI-X All Items). Nov 2001=1"
gen lwage=ln(hourpay/cpi) 
label var lwage "Log real hourly wage in main job"

recode grsswk2 .=0 if grsswk~=.
gen inc=(grsswk+grsswk2)/cpi

gen lninc=ln(inc)
recode netwk2 .=0 if netwk~=.
gen inc_net=(netwk+netwk2)/cpi
gen lninc_net=ln(inc_net)
gen lnhourpay=ln(hourpay/cpi)

ren sex male
recode male 2=0

gen black=ethcen
recode black 1/4=1 *=0
gen asian=ethcen
recode asian 5/9=1 *=0
gen othrace=ethcen
recode othrace 10/11=1 *=0

recode hiqual 1/4=1 5/14=2 15/24=3 25/30=4 31/40=5 41=6 
tab hiqual, gen(ed)
label var ed1 "College degree"
label var ed2 "Some college"
label var ed3 "GCE"
label var ed4 "GCSE"
label var ed5 "Other qualification"
label var ed6 "No qualification"
gen yearsed=hiqual
recode yearsed 1=15 2=14 3=12 4=10 5=10 6=8
gen age2=age^2
label var age2 "Age squared"
label var age "Age"
label var black "Black"
label var asian "Asian"
label var othrace "Other non-white"

* Subcategories
gen married=1 if marstt==2
gen couple=1 if marstt==2 | livtog==1 | livtog==3
recode couple .=0 
gen singlewoman=1 if male==0 & couple==0
gen couplewoman=1 if male==0 & couple==1
gen coupleman=1 if male==1 & couple==1
gen singleperson=1 if couple==0
for any singlewoman singleperson couplewoman coupleman married: recode X .=0
gen all=1

for any inc inc_net: bysort hhid wave: egen temp1=max(X) \ gen temp2=X \ recode temp2 .=0 if temp1~=. \ bysort hhid wave: egen famX=sum(temp2) \ gen lnfamX=ln(famX) \ drop temp*

* NB. 2-child familes get no WFTC above 154. Mean inc=342.
xi: reg lninc black asian othrace i.hiqual*age i.hiqual*age2 i.male*age
predict temp1 

gen predictedinc=exp(temp1)
sum predictedinc 

gen predictedpoor=1 if predictedinc<=245
recode predictedpoor .=0 if predictedinc>245 & predictedinc~=.
gen temp2=predictedpoor if wave==1
bysort persid: egen temp3=max(temp2)
replace predictedpoor=temp3
drop temp*
la var predictedpoor "1=Predicted earnings<median, 0=pred earnings>median"

tab predictedpoor

* Drops self-employed
drop if inecaca==2

gen employed=1 if inecaca==1
recode employed .=0
la var employed "Employed"

gen after_oct99=1 if refdte>19991000
recode after_oct99 .=0
label var after_oct99 "After October 1999"
gen tceligible=1 if fdpch19>0 & fdpch19~=. & fdpch19~=-9
replace tceligible=0 if fdpch19==0
la var tceligible "Eligible for family credit or WFTC"
gen treat_after=tceligible*after_oct99
la var treat_after "Eligible for TC * After Oct 1999"
for num 1/50: gen hoursX=1 if sumhrs>=X & sumhrs~=. \ replace hoursX=0 if sumhrs<X & sumhrs>0 \ la var hoursX "Employed and worked X hours per week or more"

* Ensuring that tceligible, singleperson, couplewoman, coupleman and singlewoman don't change within individuals
for any tceligible singlewoman singleperson couplewoman coupleman : gen temp1=X if wave==1 \ bysort persid: egen temp2=max(temp1) \ replace X=temp2 \ drop temp*

cd "<Active Directory>"

save uklfsC, replace 

*/

*************************************
* Simulation - single parent, 2 children under 11
*************************************
clear
set obs 3601
gen hours=_n-1
gen wage=10
gen pre_tax=hours*wage
gen after_eitc=pre_tax
replace after_eitc=pre_tax*1.4 if pre_tax<=9540
replace after_eitc=pre_tax+(9540*.4) if pre_tax>9540 & pre_tax<=12460
replace after_eitc=pre_tax+(9540*.4)-((pre_tax-12460)*.2106) if pre_tax>12460 & ((9540*.4)-((pre_tax-12460)*.2106))>0
* US/UK exchange rate in 1999 averaged 0.62 (http://www.oanda.com/convert/fxhistory)
gen xrate=.62
gen pre_tax_pounds=wage*xrate*hours
gen base_wftc=((48.8*52)+(14.85*2*52))
gen phaseout_wftc=80.65*52
gen wftc=base_wftc if (hours/52)>=16 
replace wftc=wftc+(10.8*52) if (hours/52)>=30
replace wftc=wftc-((pre_tax_pounds-phaseout_wftc)*.7) if pre_tax_pounds>phaseout_wftc
recode wftc min/0=0 .=0
gen after_wftc_pounds1=pre_tax_pounds+wftc
gen after_wftc1=after_wftc_pounds1/xrate
* New WFTC
replace base_wftc=((52.3*52)+(19.85*2*52))
replace phaseout_wftc=90*52
drop wftc
gen wftc=base_wftc if (hours/52)>=16 
replace wftc=wftc+(11.05*52) if (hours/52)>=30
replace wftc=wftc-((pre_tax_pounds-phaseout_wftc)*.55) if pre_tax_pounds>phaseout_wftc
recode wftc min/0=0 .=0
gen after_wftc_pounds2=pre_tax_pounds+wftc
gen after_wftc2=after_wftc_pounds2/xrate
keep hours pre_tax after_eitc after_wftc1 after_wftc2 pre_tax_pounds after_wftc_pounds1 after_wftc_pounds2
order hours pre_tax after_eitc after_wftc1 after_wftc2 pre_tax_pounds after_wftc_pounds1 after_wftc_pounds2

* Where's the expansion?
for num 1/2: gen wftc_value_poundsX=after_wftc_poundsX-pre_tax_pounds
gen pre_tax_pounds_weekly=pre_tax_pounds/52
sum pre_tax_pounds_weekly if wftc_value_pounds2>0 & wftc_value_pounds1==0

************************************
* What did each new job cost?
************************************
* Over the 15-month period from March 1999 to May 2000, the number of tax credit recipients 
* rose by 29 percent (from 821,300 to 1,061,400), 
* while the average credit amount rose by 16 percent (from 62.99 per week to 73.28). 
* There are approximately 12 million parents in the UK.
di "Increased public cost (total)=" 
di ((1061400*73.28*52)-(821300*62.99*52))
di "Public cost per job=" 
di ((1061400*73.28*52)-(821300*62.99*52))/(12000000 * 0.01)
di "Public cost per dollar of earnings=" 
di ((1061400*73.28*52)-(821300*62.99*52))/(12000000 * 340.122*52*0.046)
di "Earnings boost induced by each  of public expenditure=" 
di (12000000 * 340.122*52*0.046)/((1061400*73.28*52)-(821300*62.99*52))

**********************************
* With areg, then xtlogit, then robustness checks
**********************************
clear
set more off
set mem 500m
set matsize 800
cd "<Active Directory>"
use uklfsC, clear

* How many "age out"?
gen temp1=1 if fdpch19>=1 & fdpch19<=. & (wave==1 | wave==2)
gen temp2=1 if fdpch19==0 & (wave==4 | wave==5)
bysort persid: egen temp3=max(temp1)
bysort persid: egen temp4=max(temp2)
gen temp5=1 if temp3==1 & temp4==1
recode temp5 .=0
sum temp5
drop temp*

* How many "age in"?
gen temp1=1 if fdpch19==0 & (wave==1 | wave==2)
gen temp2=1 if fdpch19>=1 & fdpch19<=. & (wave==4 | wave==5)
bysort persid: egen temp3=max(temp1)
bysort persid: egen temp4=max(temp2)
gen temp5=1 if temp3==1 & temp4==1
recode temp5 .=0
sum temp5
drop temp*

* How many change status?
for any employed sumhrs hours16 hours30 lninc lninc_net lnglim limitk: bysort persid: egen temp1=max(X) \ bysort persid: egen temp2=min(X) \ gen changeX=1 if temp1~=temp2 \ recode changeX .=0 \ drop temp*
sum change*
drop change*

* Re-creating treat*after interaction
replace treat_after=tceligible*after_oct99
la var treat_after "Eligible for TC * After Oct 1999"
* Recoding hours to missing if not employed
replace sumhrs=. if employed==0
* Alternative ways of coding hours1-hours50
drop hours1-hours50
for num 16 30: gen hoursX=1 if sumhrs>=X & sumhrs~=. \ recode hoursX .=0 if sumhrs~=. \ la var hoursX "Employed and worked X hours per week or more"
*for num 1/50: gen hoursX=1 if sumhrs>=X & sumhrs~=. \ recode hoursX .=0 if employed~=. \ la var hoursX "Worked X hours per week or more"

drop if age<25 | age>59
replace lgwt=int(lgwt)

* Diffs-in-diffs tables
for X in any employed sumhrs hours16 hours30 lninc lninc_net limitk lnglim: areg X treat_after after_oct99 [fw=lgwt] if all==1, absorb(persid) cluster(persid) \ sum X [fw=lgwt] if tceligible==0 & after_oct99==0 & e(sample) \ gen cb_X=r(mean) \ gen cbse_X=r(sd) \ gen temp1=_N if tceligible==0 & after_oct99==0 & e(sample) \ egen temp2=max(temp1) \ replace cbse_X=cbse_X/temp2^.5 \ drop temp* \ sum X [fw=lgwt] if tceligible==0 & after_oct99==1 & e(sample) \ gen ca_X=r(mean) \ gen case_X=r(sd) \  gen temp1=_N if tceligible==0 & after_oct99==1 & e(sample) \ egen temp2=max(temp1) \ replace case_X=case_X/temp2^.5 \ drop temp* \ sum X [fw=lgwt] if tceligible==1 & after_oct99==0 & e(sample) \ gen tb_X=r(mean) \ gen tbse_X=r(sd) \  gen temp1=_N if tceligible==1 & after_oct99==0 & e(sample) \ egen temp2=max(temp1) \ replace tbse_X=tbse_X/temp2^.5 \ drop temp* \ sum X [fw=lgwt] if tceligible==1 & after_oct99==1 & e(sample) \ gen ta_X=r(mean) \ gen tase_X=r(sd) \  gen temp1=_N if tceligible==1 & after_oct99==1 & e(sample) \ egen temp2=max(temp1) \ replace tase_X=tase_X/temp2^.5 \ drop temp* \ gen dc_X=ca_X-cb_X \ gen dcse_X=((case_X^2)+(cbse_X^2))^.5 \ gen dt_X=ta_X-tb_X \ gen dtse_X=((tase_X^2)+(tbse_X^2))^.5 \ gen dd_X=dt_X-dc_X \ gen ddse_X=((dcse_X^2)+(dtse_X^2))^.5 
sum dd*
* Weighting on the inverse of the propensity score
psmatch2 tceligible male age black asian othrace yearsed couple if wave==1, llr outcome(employed)
gen pscorewgt=1/_pscore
drop cb_* cbse_* ca_* case_* tb_* tbse_* ta_* tase_* dc_* dcse_* dt_* dtse_* dd_* ddse_*
for X in any employed sumhrs hours16 hours30 lninc lninc_net limitk lnglim: areg X treat_after after_oct99 [aw=pscorewgt] if all==1, absorb(persid) cluster(persid) \ sum X [aw=pscorewgt] if tceligible==0 & after_oct99==0 & e(sample) \ gen cb_X=r(mean) \ gen cbse_X=r(sd) \ gen temp1=_N if tceligible==0 & after_oct99==0 & e(sample) \ egen temp2=max(temp1) \ replace cbse_X=cbse_X/temp2^.5 \ drop temp* \ sum X [aw=pscorewgt] if tceligible==0 & after_oct99==1 & e(sample) \ gen ca_X=r(mean) \ gen case_X=r(sd) \  gen temp1=_N if tceligible==0 & after_oct99==1 & e(sample) \ egen temp2=max(temp1) \ replace case_X=case_X/temp2^.5 \ drop temp* \ sum X [aw=pscorewgt] if tceligible==1 & after_oct99==0 & e(sample) \ gen tb_X=r(mean) \ gen tbse_X=r(sd) \  gen temp1=_N if tceligible==1 & after_oct99==0 & e(sample) \ egen temp2=max(temp1) \ replace tbse_X=tbse_X/temp2^.5 \ drop temp* \ sum X [aw=pscorewgt] if tceligible==1 & after_oct99==1 & e(sample) \ gen ta_X=r(mean) \ gen tase_X=r(sd) \  gen temp1=_N if tceligible==1 & after_oct99==1 & e(sample) \ egen temp2=max(temp1) \ replace tase_X=tase_X/temp2^.5 \ drop temp* \ gen dc_X=ca_X-cb_X \ gen dcse_X=((case_X^2)+(cbse_X^2))^.5 \ gen dt_X=ta_X-tb_X \ gen dtse_X=((tase_X^2)+(tbse_X^2))^.5 \ gen dd_X=dt_X-dc_X \ gen ddse_X=((dcse_X^2)+(dtse_X^2))^.5 
sum dd*

* Creating 6 new outreg tables
for any all: areg employed treat_after after_oct99 [aw=lgwt] if X==1, absorb(persid) cluster(hhid) \ outreg using table1.doc, coefastr se nocons 3aster replace ti("All") ct("drop") bdec(3) bracket \ outreg using table2.doc, coefastr se nocons 3aster replace ti("Predicted Poor") ct("drop") bdec(3) bracket \ outreg using table3.doc, coefastr se nocons 3aster replace ti("Single Women") ct("drop") bdec(3) bracket \ outreg using table4.doc, coefastr se nocons 3aster replace ti("Women in couples") ct("drop") bdec(3) bracket \ outreg using table5.doc, coefastr se nocons 3aster replace ti("Men in couples") ct("drop") bdec(3) bracket \ outreg using table6.doc, coefastr se nocons 3aster replace ti("Comparing regions") ct("drop") bdec(3) bracket \ outreg using table7.doc, coefastr se nocons 3aster replace ti("Using xtlogit") ct("drop") bdec(3) bracket \ outreg using table8.doc, coefastr se nocons 3aster replace ti("Robustness checks") ct("drop") bdec(3) bracket 

* Regressions - comparing those with and without kids
* We look at all people, then those in two subgroups - 
* single women, and the predicted poor
for Y in any employed sumhrs hours16 hours30 lninc lninc_net limitk lnglim: areg Y treat_after after_oct99 [fw=lgwt] if all==1, absorb(persid) cluster(persid) \ outreg using table1.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 
for Y in any employed sumhrs hours16 hours30 lninc lninc_net limitk lnglim: areg Y treat_after after_oct99 [fw=lgwt] if predictedpoor==1, absorb(persid) cluster(persid) \ outreg using table2.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 
for Y in any employed sumhrs hours16 hours30 lninc lninc_net limitk lnglim: areg Y treat_after after_oct99 [fw=lgwt] if singlewoman==1, absorb(persid) cluster(persid) \ outreg using table3.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 
for Y in any employed sumhrs hours16 hours30 lninc lninc_net limitk lnglim: areg Y treat_after after_oct99 [fw=lgwt] if couplewoman==1, absorb(persid) cluster(persid) \ outreg using table4.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 
for Y in any employed sumhrs hours16 hours30 lninc lninc_net limitk lnglim: areg Y treat_after after_oct99 [fw=lgwt] if coupleman==1, absorb(persid) cluster(persid) \ outreg using table5.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 

* Alternative ways of coding hours1-hours50
drop hours16 hours30
for num 1/50: gen hoursX=1 if sumhrs>=X & sumhrs~=. \ recode hoursX .=0 if employed~=. \ la var hoursX "Worked X hours per week or more"

for Y in num 1/50: areg hoursY treat_after after_oct99 [fw=lgwt] if all==1, absorb(persid) cluster(persid) \ outreg using table1.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 
for Y in num 1/50: areg hoursY treat_after after_oct99 [fw=lgwt] if predictedpoor==1, absorb(persid) cluster(persid) \ outreg using table2.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 
for Y in num 1/50: areg hoursY treat_after after_oct99 [fw=lgwt] if singlewoman==1, absorb(persid) cluster(persid) \ outreg using table3.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 
for Y in num 1/50: areg hoursY treat_after after_oct99 [fw=lgwt] if couplewoman==1, absorb(persid) cluster(persid) \ outreg using table4.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 
for Y in num 1/50: areg hoursY treat_after after_oct99 [fw=lgwt] if coupleman==1, absorb(persid) cluster(persid) \ outreg using table5.doc, coefastr se nocons 3aster append ct("Y") bdec(3) bracket 

* Checking R-squared without FE
for Y in any employed sumhrs hours16 hours30 lninc lninc_net limitk lnglim: reg Y treat_after after_oct99 [fw=lgwt] if all==1, cluster(persid) 

* Robustness checks - interacting treat_after*age, treat_after*yearsed, treat_after*black
* Ensuring that tceligible, pooregion, singleperson, couplewoman, coupleman and singlewoman don't change within individuals
for any tceligible singlewoman singleperson couplewoman coupleman poorregion: gen temp1=X if wave==1 \ bysort persid: egen temp2=max(temp1) \ replace X=temp2 \ drop temp*
gen treat_age=tceligible*age
gen treat_ed=tceligible*yearsed
gen treat_bk=tceligible*black
gen treat_poorreg=tceligible*poorregion
areg employed treat_after after_oct99 treat_age treat_ed treat_bk treat_poorreg [fw=lgwt] if all==1, absorb(persid) cluster(persid) 

/*

* This bit is temporarily asterisked out, since it runs very slowly
* XTLOGIT
iis persid
tis wave
for Y in any employed hours16 hours30: xtlogit Y treat_after after_oct99 [iw=lgwt] if all==1, fe nolog \ mfx compute, predict(pu0) at(mean) noesample \ outreg using table7.doc, coefastr se nocons 3aster append ct("All - Y") bdec(3) bracket margin
for Y in any employed hours16 hours30: xtlogit Y treat_after after_oct99 [iw=lgwt] if predictedpoor==1, fe nolog \ mfx compute, predict(pu0) at(mean) noesample \ outreg using table7.doc, coefastr se nocons 3aster append ct("Predicted Poor - Y") bdec(3) bracket margin 
for Y in any employed hours16 hours30: xtlogit Y treat_after after_oct99 [iw=lgwt] if singlewoman==1, fe nolog \ mfx compute, predict(pu0) at(mean) noesample \ outreg using table7.doc, coefastr se nocons 3aster append ct("Single Women - Y") bdec(3) bracket margin 

*/

* Robustness Checks
* Excl wave 1, and just looking at taxyear 1999-2000
gen restrictedsample=1
replace restrictedsample=0 if (wave==5 & week>5) | wave==1
for Y in any employed sumhrs hours16 hours30: areg Y treat_after after_oct99 [fw=lgwt] if all==1 & restrictedsample==1, absorb(persid) cluster(persid) \ outreg using table8.doc, coefastr se nocons 3aster append ct("All - Y") bdec(3) bracket 
for Y in any employed sumhrs hours16 hours30: areg Y treat_after after_oct99 [fw=lgwt] if predictedpoor==1 & restrictedsample==1, absorb(persid) cluster(persid) \ outreg using table8.doc, coefastr se nocons 3aster append ct("Predicted Poor - Y") bdec(3) bracket 
for Y in any employed sumhrs hours16 hours30: areg Y treat_after after_oct99 [fw=lgwt] if singlewoman==1 & restrictedsample==1, absorb(persid) cluster(persid) \ outreg using table8.doc, coefastr se nocons 3aster append ct("Single Women - Y") bdec(3) bracket 
for Y in any employed sumhrs hours16 hours30: areg Y treat_after after_oct99 [fw=lgwt] if couplewoman==1 & restrictedsample==1, absorb(persid) cluster(persid) \ outreg using table8.doc, coefastr se nocons 3aster append ct("Coupled Women - Y") bdec(3) bracket 
for Y in any employed sumhrs hours16 hours30: areg Y treat_after after_oct99 [fw=lgwt] if coupleman==1 & restrictedsample==1, absorb(persid) cluster(persid) \ outreg using table8.doc, coefastr se nocons 3aster append ct("Coupled Men - Y") bdec(3) bracket 

* Redoing, excl wave 1 (UK Min Wage introduced on 13 April 1999. Dickens & Manning find that virtually all the changes occurred within two months of the introduction, so we exclude Wave 1)
* Here, we retest all three main specifications
for X in any all predictedpoor singlewoman couplewoman coupleman : for Y in any employed hours16 hours30 lnhourpay lninc lninc_net: areg Y treat_after after_oct99 [fw=lgwt] if X==1 & wave~=1, absorb(persid) cluster(persid)

* Tax and NIC changes (tax year is 6 April 1999-5 April 2000
* Bottom tax rate cut from 20p to 10p in April 2000.
* Various NIC changes in April 1999 and April 2000.
gen taxyear1999_2000=1
replace taxyear1999_2000=0 if (wave==5 & week>5) | (wave==1 & week<6)
for X in any all predictedpoor singlewoman couplewoman coupleman : for Y in any employed hours16 hours30 lnhourpay lninc lninc_net: areg Y treat_after after_oct99 [fw=lgwt] if X==1 & taxyear1999_2000==1, absorb(persid) cluster(persid)

***********************
* For sample size only
***********************
clear
set more off
set mem 500m
set matsize 800
cd "<Active Directory>"
use uklfsC, clear
drop if age<25 | age>59
replace lgwt=int(lgwt)
replace treat_after=tceligible*after_oct99
replace sumhrs=. if employed==0
drop hours1-hours50
for num 16 30: gen hoursX=1 if sumhrs>=X & sumhrs~=. \ recode hoursX .=0 if sumhrs~=. \ la var hoursX "Employed and worked X hours per week or more"
gen restrictedsample=1
replace restrictedsample=0 if (wave==5 & week>5) | wave==1

* Summary statistics
ren fdpch19 children
ren othrace othernonwhite
ren yearsed educationyears
ren sumhrs weeklyhours
ren hourpay hourlywage
ren inc weeklyincomepretax
ren inc_net weeklyincomeposttax
ren lnglim healthproblem
ren limitk limitinghealthproblem
ren couple incouple
* Note: The first line gives means and SDs (weighted). The second line gives sample sizes.
for any all predictedpoor: tabstat male age black asian othernonwhite educationyears incouple children employed weeklyhours hours16 hours30 hourlywage weeklyincomepretax weeklyincomeposttax healthproblem limitinghealthproblem [fw=lgwt] if X==1 & wave==1, stats(mean sd) col(stat) \ tabstat male age black asian othernonwhite educationyears incouple children employed weeklyhours hours16 hours30 hourlywage weeklyincomepretax weeklyincomeposttax healthproblem limitinghealthproblem [fw=lgwt] if X==1 & wave==1 & tceligible==1, stats(mean sd) col(stat) \ tabstat male age black asian othernonwhite educationyears incouple children employed weeklyhours hours16 hours30 hourlywage weeklyincomepretax weeklyincomeposttax healthproblem limitinghealthproblem [fw=lgwt] if X==1 & wave==1 & tceligible==0, stats(mean sd) col(stat)
for any all predictedpoor: tabstat male age black asian othernonwhite educationyears incouple children employed weeklyhours hours16 hours30 hourlywage weeklyincomepretax weeklyincomeposttax healthproblem limitinghealthproblem if X==1 & wave==1, stats(n) col(stat) \ tabstat male age black asian othernonwhite educationyears incouple children employed weeklyhours hours16 hours30 hourlywage weeklyincomepretax weeklyincomeposttax healthproblem limitinghealthproblem if X==1 & wave==1 & tceligible==1, stats(n) col(stat) \ tabstat male age black asian othernonwhite educationyears incouple children employed weeklyhours hours16 hours30 hourlywage weeklyincomepretax weeklyincomeposttax healthproblem limitinghealthproblem if X==1 & wave==1 & tceligible==0, stats(n) col(stat)

* How do the age distributions compare?
for num 0/1: sum age if all==1 & wave==1 & tceligible==X [fw=lgwt],d

